// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// WebPubSubService.
/// </summary>
public partial class WebPubSubService : ProvisionableResource
{
    /// <summary>
    /// The name of the resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// A class represent managed identities used for request and response.
    /// Current supported identity types: None, SystemAssigned, UserAssigned.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// DisableLocalAuth             Enable or disable aad auth
    /// When set as true, connection with AuthType=aad won&apos;t
    /// work.
    /// </summary>
    public BicepValue<bool> IsAadAuthDisabled 
    {
        get { Initialize(); return _isAadAuthDisabled!; }
        set { Initialize(); _isAadAuthDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAadAuthDisabled;

    /// <summary>
    /// Request client certificate during TLS handshake if enabled.
    /// </summary>
    public BicepValue<bool> IsClientCertEnabled 
    {
        get { Initialize(); return _isClientCertEnabled!; }
        set { Initialize(); _isClientCertEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isClientCertEnabled;

    /// <summary>
    /// DisableLocalAuth             Enable or disable local auth with
    /// AccessKey             When set as true, connection with AccessKey=xxx
    /// won&apos;t work.
    /// </summary>
    public BicepValue<bool> IsLocalAuthDisabled 
    {
        get { Initialize(); return _isLocalAuthDisabled!; }
        set { Initialize(); _isLocalAuthDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalAuthDisabled;

    /// <summary>
    /// Live trace configuration of a Microsoft.SignalRService resource.
    /// </summary>
    public LiveTraceConfiguration LiveTraceConfiguration 
    {
        get { Initialize(); return _liveTraceConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _liveTraceConfiguration, value); }
    }
    private LiveTraceConfiguration? _liveTraceConfiguration;

    /// <summary>
    /// Network ACLs for the resource.
    /// </summary>
    public WebPubSubNetworkAcls NetworkAcls 
    {
        get { Initialize(); return _networkAcls!; }
        set { Initialize(); AssignOrReplace(ref _networkAcls, value); }
    }
    private WebPubSubNetworkAcls? _networkAcls;

    /// <summary>
    /// Enable or disable public network access. Default to
    /// &quot;Enabled&quot;.             When it&apos;s Enabled, network ACLs
    /// still apply.             When it&apos;s Disabled, public network
    /// access is always disabled no matter what you set in network ACLs.
    /// </summary>
    public BicepValue<string> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<string>? _publicNetworkAccess;

    /// <summary>
    /// Gets or sets the list of category configurations.
    /// </summary>
    public BicepList<ResourceLogCategory> ResourceLogCategories 
    {
        get { Initialize(); return _resourceLogCategories!; }
        set { Initialize(); _resourceLogCategories!.Assign(value); }
    }
    private BicepList<ResourceLogCategory>? _resourceLogCategories;

    /// <summary>
    /// The billing information of the resource.
    /// </summary>
    public BillingInfoSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private BillingInfoSku? _sku;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The publicly accessible IP of the resource.
    /// </summary>
    public BicepValue<string> ExternalIP 
    {
        get { Initialize(); return _externalIP!; }
    }
    private BicepValue<string>? _externalIP;

    /// <summary>
    /// FQDN of the service instance.
    /// </summary>
    public BicepValue<string> HostName 
    {
        get { Initialize(); return _hostName!; }
    }
    private BicepValue<string>? _hostName;

    /// <summary>
    /// Deprecated.
    /// </summary>
    public BicepValue<string> HostNamePrefix 
    {
        get { Initialize(); return _hostNamePrefix!; }
    }
    private BicepValue<string>? _hostNamePrefix;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Private endpoint connections to the resource.
    /// </summary>
    public BicepList<WebPubSubPrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<WebPubSubPrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// Provisioning state of the resource.
    /// </summary>
    public BicepValue<WebPubSubProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<WebPubSubProvisioningState>? _provisioningState;

    /// <summary>
    /// The publicly accessible port of the resource which is designed for
    /// browser/client side usage.
    /// </summary>
    public BicepValue<int> PublicPort 
    {
        get { Initialize(); return _publicPort!; }
    }
    private BicepValue<int>? _publicPort;

    /// <summary>
    /// The publicly accessible port of the resource which is designed for
    /// customer server side usage.
    /// </summary>
    public BicepValue<int> ServerPort 
    {
        get { Initialize(); return _serverPort!; }
    }
    private BicepValue<int>? _serverPort;

    /// <summary>
    /// The list of shared private link resources.
    /// </summary>
    public BicepList<WebPubSubSharedPrivateLinkData> SharedPrivateLinkResources 
    {
        get { Initialize(); return _sharedPrivateLinkResources!; }
    }
    private BicepList<WebPubSubSharedPrivateLinkData>? _sharedPrivateLinkResources;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Version of the resource. Probably you need the same or higher version
    /// of client SDKs.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Creates a new WebPubSubService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebPubSubService resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebPubSubService.</param>
    public WebPubSubService(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.SignalRService/webPubSub", resourceVersion ?? "2024-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebPubSubService.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _isAadAuthDisabled = DefineProperty<bool>("IsAadAuthDisabled", ["properties", "disableAadAuth"]);
        _isClientCertEnabled = DefineProperty<bool>("IsClientCertEnabled", ["properties", "tls", "clientCertEnabled"]);
        _isLocalAuthDisabled = DefineProperty<bool>("IsLocalAuthDisabled", ["properties", "disableLocalAuth"]);
        _liveTraceConfiguration = DefineModelProperty<LiveTraceConfiguration>("LiveTraceConfiguration", ["properties", "liveTraceConfiguration"]);
        _networkAcls = DefineModelProperty<WebPubSubNetworkAcls>("NetworkAcls", ["properties", "networkACLs"]);
        _publicNetworkAccess = DefineProperty<string>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _resourceLogCategories = DefineListProperty<ResourceLogCategory>("ResourceLogCategories", ["properties", "resourceLogConfiguration", "categories"]);
        _sku = DefineModelProperty<BillingInfoSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _externalIP = DefineProperty<string>("ExternalIP", ["properties", "externalIP"], isOutput: true);
        _hostName = DefineProperty<string>("HostName", ["properties", "hostName"], isOutput: true);
        _hostNamePrefix = DefineProperty<string>("HostNamePrefix", ["properties", "hostNamePrefix"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<WebPubSubPrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<WebPubSubProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _publicPort = DefineProperty<int>("PublicPort", ["properties", "publicPort"], isOutput: true);
        _serverPort = DefineProperty<int>("ServerPort", ["properties", "serverPort"], isOutput: true);
        _sharedPrivateLinkResources = DefineListProperty<WebPubSubSharedPrivateLinkData>("SharedPrivateLinkResources", ["properties", "sharedPrivateLinkResources"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _version = DefineProperty<string>("Version", ["properties", "version"], isOutput: true);
    }

    /// <summary>
    /// Supported WebPubSubService resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-03-01.
        /// </summary>
        public static readonly string V2024_03_01 = "2024-03-01";

        /// <summary>
        /// 2023-02-01.
        /// </summary>
        public static readonly string V2023_02_01 = "2023-02-01";

        /// <summary>
        /// 2021-10-01.
        /// </summary>
        public static readonly string V2021_10_01 = "2021-10-01";

        /// <summary>
        /// 2020-05-01.
        /// </summary>
        public static readonly string V2020_05_01 = "2020-05-01";
    }

    /// <summary>
    /// Creates a reference to an existing WebPubSubService.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the WebPubSubService resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the WebPubSubService.</param>
    /// <returns>The existing WebPubSubService resource.</returns>
    public static WebPubSubService FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this WebPubSubService resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);

    /// <summary>
    /// Get access keys for this WebPubSubService resource.
    /// </summary>
    /// <returns>The keys for this WebPubSubService resource.</returns>
    public WebPubSubKeys GetKeys()
    {
        WebPubSubKeys key = new();
        ((IBicepValue)key).Expression = new FunctionCallExpression(new MemberExpression(new IdentifierExpression(BicepIdentifier), "listKeys"));
        return key;
    }

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this WebPubSubService.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(WebPubSubBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{WebPubSubBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// WebPubSubService.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(WebPubSubBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{WebPubSubBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
