// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using System;
using System.ComponentModel;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// Built-in WebPubSub roles that you can assign to users, groups, service
/// principals, and managed identities.
/// </summary>
/// <param name="value">The ID value of the role.</param>
public readonly struct WebPubSubBuiltInRole(string value) : IEquatable<WebPubSubBuiltInRole>
{
    private readonly string _value = value ?? throw new ArgumentNullException(nameof(value));

    /// <summary>
    /// Read-only access to Azure Web PubSub Service REST APIs
    /// </summary>
    public static WebPubSubBuiltInRole WebPubSubServiceReader { get; } = new(WebPubSubServiceReaderValue);
    internal const string WebPubSubServiceReaderValue = "bfb1c7d2-fb1a-466b-b2ba-aee63b92deaf";

    /// <summary>
    /// Full access to Azure Web PubSub Service REST APIs
    /// </summary>
    public static WebPubSubBuiltInRole WebPubSubServiceOwner { get; } = new(WebPubSubServiceOwnerValue);
    internal const string WebPubSubServiceOwnerValue = "12cf5a90-567b-43ae-8102-96cf46c7d9b4";

    /// <summary>
    /// Create, Read, Update, and Delete Web PubSub service resources
    /// </summary>
    public static WebPubSubBuiltInRole WebPubSubContributor { get; } = new(WebPubSubContributorValue);
    internal const string WebPubSubContributorValue = "8cf5e20a-e4b2-4e9d-b3a1-5ceb692c2761";

    /// <summary>
    /// Try to get the name of a built-in WebPubSub role from its ID value.
    /// </summary>
    /// <param name="value">The role value.</param>
    /// <returns>
    /// The name of the built-in WebPubSub role if known, otherwise the ID will be returned.
    /// </returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public static string GetBuiltInRoleName(WebPubSubBuiltInRole value) =>
        value._value switch
        {
            WebPubSubServiceReaderValue => nameof(WebPubSubServiceReader),
            WebPubSubServiceOwnerValue => nameof(WebPubSubServiceOwner),
            WebPubSubContributorValue => nameof(WebPubSubContributor),
            _ => value._value
        };

    /// <summary>
    /// Determines if two WebPubSubBuiltInRole values are the same.
    /// </summary>
    /// <param name="left">The first WebPubSubBuiltInRole to compare.</param>
    /// <param name="right">The second WebPubSubBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are the same; otherwise, false.</returns>
    public static bool operator ==(WebPubSubBuiltInRole left, WebPubSubBuiltInRole right) => left.Equals(right);

    /// <summary>
    /// Determines if two WebPubSubBuiltInRole values are different.
    /// </summary>
    /// <param name="left">The first WebPubSubBuiltInRole to compare.</param>
    /// <param name="right">The second WebPubSubBuiltInRole to compare.</param>
    /// <returns>True if <paramref name="left"/> and <paramref name="right"/> are different; otherwise, false.</returns>
    public static bool operator !=(WebPubSubBuiltInRole left, WebPubSubBuiltInRole right) => !left.Equals(right);

    /// <summary>
    /// Converts a string to a WebPubSubBuiltInRole.
    /// </summary>
    /// <param name="value">The string value to convert.</param>
    public static implicit operator WebPubSubBuiltInRole(string value) => new(value);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override bool Equals(object? obj) => obj is WebPubSubBuiltInRole other && Equals(other);

    /// <inheritdoc/>
    public bool Equals(WebPubSubBuiltInRole other) => string.Equals(_value, other._value, StringComparison.Ordinal);

    /// <inheritdoc/>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override int GetHashCode() => _value?.GetHashCode() ?? 0;

    /// <inheritdoc/>
    public override string ToString() => _value;
}
