// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// Network ACLs for the resource.
/// </summary>
public partial class WebPubSubNetworkAcls : ProvisionableConstruct
{
    /// <summary>
    /// Azure Networking ACL Action.
    /// </summary>
    public BicepValue<AclAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<AclAction>? _defaultAction;

    /// <summary>
    /// Network ACL.
    /// </summary>
    public PublicNetworkAcls PublicNetwork 
    {
        get { Initialize(); return _publicNetwork!; }
        set { Initialize(); AssignOrReplace(ref _publicNetwork, value); }
    }
    private PublicNetworkAcls? _publicNetwork;

    /// <summary>
    /// ACLs for requests from private endpoints.
    /// </summary>
    public BicepList<PrivateEndpointAcl> PrivateEndpoints 
    {
        get { Initialize(); return _privateEndpoints!; }
        set { Initialize(); _privateEndpoints!.Assign(value); }
    }
    private BicepList<PrivateEndpointAcl>? _privateEndpoints;

    /// <summary>
    /// Creates a new WebPubSubNetworkAcls.
    /// </summary>
    public WebPubSubNetworkAcls()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebPubSubNetworkAcls.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _defaultAction = DefineProperty<AclAction>("DefaultAction", ["defaultAction"]);
        _publicNetwork = DefineModelProperty<PublicNetworkAcls>("PublicNetwork", ["publicNetwork"]);
        _privateEndpoints = DefineListProperty<PrivateEndpointAcl>("PrivateEndpoints", ["privateEndpoints"]);
    }
}
