// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// Properties of event handler.
/// </summary>
public partial class WebPubSubEventHandler : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the EventHandler URL template. You can use a predefined
    /// parameter {hub} and {event} inside the template, the value of the
    /// EventHandler URL is dynamically calculated when the client request
    /// comes in.             For example, UrlTemplate can be
    /// `http://example.com/api/{hub}/{event}`. The host part can&apos;t
    /// contains parameters.
    /// </summary>
    public BicepValue<string> UrlTemplate 
    {
        get { Initialize(); return _urlTemplate!; }
        set { Initialize(); _urlTemplate!.Assign(value); }
    }
    private BicepValue<string>? _urlTemplate;

    /// <summary>
    /// Gets or sets the matching pattern for event names.             There
    /// are 3 kind of patterns supported:                 1. &quot;*&quot;, it
    /// to matches any event name                 2. Combine multiple events
    /// with &quot;,&quot;, for example &quot;event1,event2&quot;, it matches
    /// event &quot;event1&quot; and &quot;event2&quot;                 3. The
    /// single event name, for example, &quot;event1&quot;, it matches
    /// &quot;event1&quot;
    /// </summary>
    public BicepValue<string> UserEventPattern 
    {
        get { Initialize(); return _userEventPattern!; }
        set { Initialize(); _userEventPattern!.Assign(value); }
    }
    private BicepValue<string>? _userEventPattern;

    /// <summary>
    /// Gets ot sets the list of system events.
    /// </summary>
    public BicepList<string> SystemEvents 
    {
        get { Initialize(); return _systemEvents!; }
        set { Initialize(); _systemEvents!.Assign(value); }
    }
    private BicepList<string>? _systemEvents;

    /// <summary>
    /// Upstream auth settings. If not set, no auth is used for upstream
    /// messages.
    /// </summary>
    public UpstreamAuthSettings Auth 
    {
        get { Initialize(); return _auth!; }
        set { Initialize(); AssignOrReplace(ref _auth, value); }
    }
    private UpstreamAuthSettings? _auth;

    /// <summary>
    /// Creates a new WebPubSubEventHandler.
    /// </summary>
    public WebPubSubEventHandler()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of WebPubSubEventHandler.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _urlTemplate = DefineProperty<string>("UrlTemplate", ["urlTemplate"]);
        _userEventPattern = DefineProperty<string>("UserEventPattern", ["userEventPattern"]);
        _systemEvents = DefineListProperty<string>("SystemEvents", ["systemEvents"]);
        _auth = DefineModelProperty<UpstreamAuthSettings>("Auth", ["auth"]);
    }
}
