// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// Upstream auth settings. If not set, no auth is used for upstream messages.
/// </summary>
public partial class UpstreamAuthSettings : ProvisionableConstruct
{
    /// <summary>
    /// Upstream auth type enum.
    /// </summary>
    public BicepValue<UpstreamAuthType> AuthType 
    {
        get { Initialize(); return _authType!; }
        set { Initialize(); _authType!.Assign(value); }
    }
    private BicepValue<UpstreamAuthType>? _authType;

    /// <summary>
    /// The Resource indicating the App ID URI of the target resource.
    /// It also appears in the aud (audience) claim of the issued
    /// token.
    /// </summary>
    public BicepValue<string> ManagedIdentityResource 
    {
        get { Initialize(); return _managedIdentityResource!; }
        set { Initialize(); _managedIdentityResource!.Assign(value); }
    }
    private BicepValue<string>? _managedIdentityResource;

    /// <summary>
    /// Creates a new UpstreamAuthSettings.
    /// </summary>
    public UpstreamAuthSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of UpstreamAuthSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _authType = DefineProperty<UpstreamAuthType>("AuthType", ["type"]);
        _managedIdentityResource = DefineProperty<string>("ManagedIdentityResource", ["managedIdentity", "resource"]);
    }
}
