// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// Network ACL.
/// </summary>
public partial class PublicNetworkAcls : ProvisionableConstruct
{
    /// <summary>
    /// Allowed request types. The value can be one or more of:
    /// ClientConnection, ServerConnection, RESTAPI.
    /// </summary>
    public BicepList<WebPubSubRequestType> Allow 
    {
        get { Initialize(); return _allow!; }
        set { Initialize(); _allow!.Assign(value); }
    }
    private BicepList<WebPubSubRequestType>? _allow;

    /// <summary>
    /// Denied request types. The value can be one or more of:
    /// ClientConnection, ServerConnection, RESTAPI.
    /// </summary>
    public BicepList<WebPubSubRequestType> Deny 
    {
        get { Initialize(); return _deny!; }
        set { Initialize(); _deny!.Assign(value); }
    }
    private BicepList<WebPubSubRequestType>? _deny;

    /// <summary>
    /// Creates a new PublicNetworkAcls.
    /// </summary>
    public PublicNetworkAcls()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PublicNetworkAcls.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allow = DefineListProperty<WebPubSubRequestType>("Allow", ["allow"]);
        _deny = DefineListProperty<WebPubSubRequestType>("Deny", ["deny"]);
    }
}
