// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// Live trace category configuration of a Microsoft.SignalRService resource.
/// </summary>
public partial class LiveTraceCategory : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the live trace category&apos;s name.             Available
    /// values: ConnectivityLogs, MessagingLogs.             Case insensitive.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Indicates whether or the live trace category is enabled.
    /// </summary>
    public BicepValue<string> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<string>? _isEnabled;

    /// <summary>
    /// Creates a new LiveTraceCategory.
    /// </summary>
    public LiveTraceCategory()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LiveTraceCategory.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _isEnabled = DefineProperty<string>("IsEnabled", ["enabled"]);
    }
}
