// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.WebPubSub;

/// <summary>
/// The billing information of the resource.
/// </summary>
public partial class BillingInfoSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of the SKU. Required.                           Allowed
    /// values: Standard_S1, Free_F1
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Optional tier of this particular SKU. &apos;Standard&apos; or
    /// &apos;Free&apos;.                           `Basic` is deprecated, use
    /// `Standard` instead.
    /// </summary>
    public BicepValue<WebPubSubSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<WebPubSubSkuTier>? _tier;

    /// <summary>
    /// Not used. Retained for future use.
    /// </summary>
    public BicepValue<string> Size 
    {
        get { Initialize(); return _size!; }
    }
    private BicepValue<string>? _size;

    /// <summary>
    /// Not used. Retained for future use.
    /// </summary>
    public BicepValue<string> Family 
    {
        get { Initialize(); return _family!; }
    }
    private BicepValue<string>? _family;

    /// <summary>
    /// Optional, integer. The unit count of the resource. 1 by default.
    /// If present, following values are allowed:
    /// Free: 1                  Standard: 1,2,5,10,20,50,100
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new BillingInfoSku.
    /// </summary>
    public BillingInfoSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of BillingInfoSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _tier = DefineProperty<WebPubSubSkuTier>("Tier", ["tier"]);
        _size = DefineProperty<string>("Size", ["size"], isOutput: true);
        _family = DefineProperty<string>("Family", ["family"], isOutput: true);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
