// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Authorization;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using Azure.Provisioning.Roles;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Storage;

/// <summary>
/// StorageAccount.
/// </summary>
public partial class StorageAccount : ProvisionableResource
{
    /// <summary>
    /// The name of the storage account within the specified resource group.
    /// Storage account names must be between 3 and 24 characters in length
    /// and use numbers and lower-case letters only.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Required. Indicates the type of storage account.
    /// </summary>
    public BicepValue<StorageKind> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<StorageKind>? _kind;

    /// <summary>
    /// Required. Gets or sets the location of the resource. This will be one
    /// of the supported and registered Azure Geo Regions (e.g. West US, East
    /// US, Southeast Asia, etc.). The geo region of a resource cannot be
    /// changed once it is created, but if an identical geo region is
    /// specified on update, the request will succeed.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Required. Gets or sets the SKU name.
    /// </summary>
    public StorageSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private StorageSku? _sku;

    /// <summary>
    /// Required for storage accounts where kind = BlobStorage. The access tier
    /// is used for billing. The &apos;Premium&apos; access tier is the
    /// default value for premium block blobs storage account type and it
    /// cannot be changed for the premium block blobs storage account type.
    /// </summary>
    public BicepValue<StorageAccountAccessTier> AccessTier 
    {
        get { Initialize(); return _accessTier!; }
        set { Initialize(); _accessTier!.Assign(value); }
    }
    private BicepValue<StorageAccountAccessTier>? _accessTier;

    /// <summary>
    /// Allow or disallow public access to all blobs or containers in the
    /// storage account. The default interpretation is true for this property.
    /// </summary>
    public BicepValue<bool> AllowBlobPublicAccess 
    {
        get { Initialize(); return _allowBlobPublicAccess!; }
        set { Initialize(); _allowBlobPublicAccess!.Assign(value); }
    }
    private BicepValue<bool>? _allowBlobPublicAccess;

    /// <summary>
    /// Allow or disallow cross AAD tenant object replication. The default
    /// interpretation is true for this property.
    /// </summary>
    public BicepValue<bool> AllowCrossTenantReplication 
    {
        get { Initialize(); return _allowCrossTenantReplication!; }
        set { Initialize(); _allowCrossTenantReplication!.Assign(value); }
    }
    private BicepValue<bool>? _allowCrossTenantReplication;

    /// <summary>
    /// Restrict copy to and from Storage Accounts within an AAD tenant or with
    /// Private Links to the same VNet.
    /// </summary>
    public BicepValue<AllowedCopyScope> AllowedCopyScope 
    {
        get { Initialize(); return _allowedCopyScope!; }
        set { Initialize(); _allowedCopyScope!.Assign(value); }
    }
    private BicepValue<AllowedCopyScope>? _allowedCopyScope;

    /// <summary>
    /// Indicates whether the storage account permits requests to be authorized
    /// with the account access key via Shared Key. If false, then all
    /// requests, including shared access signatures, must be authorized with
    /// Azure Active Directory (Azure AD). The default value is null, which is
    /// equivalent to true.
    /// </summary>
    public BicepValue<bool> AllowSharedKeyAccess 
    {
        get { Initialize(); return _allowSharedKeyAccess!; }
        set { Initialize(); _allowSharedKeyAccess!.Assign(value); }
    }
    private BicepValue<bool>? _allowSharedKeyAccess;

    /// <summary>
    /// Provides the identity based authentication settings for Azure Files.
    /// </summary>
    public FilesIdentityBasedAuthentication AzureFilesIdentityBasedAuthentication 
    {
        get { Initialize(); return _azureFilesIdentityBasedAuthentication!; }
        set { Initialize(); AssignOrReplace(ref _azureFilesIdentityBasedAuthentication, value); }
    }
    private FilesIdentityBasedAuthentication? _azureFilesIdentityBasedAuthentication;

    /// <summary>
    /// User domain assigned to the storage account. Name is the CNAME source.
    /// Only one custom domain is supported per storage account at this time.
    /// To clear the existing custom domain, use an empty string for the
    /// custom domain name property.
    /// </summary>
    public StorageCustomDomain CustomDomain 
    {
        get { Initialize(); return _customDomain!; }
        set { Initialize(); AssignOrReplace(ref _customDomain, value); }
    }
    private StorageCustomDomain? _customDomain;

    /// <summary>
    /// Allows you to specify the type of endpoint. Set this to AzureDNSZone to
    /// create a large number of accounts in a single subscription, which
    /// creates accounts in an Azure DNS Zone and the endpoint URL will have
    /// an alphanumeric DNS Zone identifier.
    /// </summary>
    public BicepValue<StorageDnsEndpointType> DnsEndpointType 
    {
        get { Initialize(); return _dnsEndpointType!; }
        set { Initialize(); _dnsEndpointType!.Assign(value); }
    }
    private BicepValue<StorageDnsEndpointType>? _dnsEndpointType;

    /// <summary>
    /// Allows https traffic only to storage service if sets to true. The
    /// default value is true since API version 2019-04-01.
    /// </summary>
    public BicepValue<bool> EnableHttpsTrafficOnly 
    {
        get { Initialize(); return _enableHttpsTrafficOnly!; }
        set { Initialize(); _enableHttpsTrafficOnly!.Assign(value); }
    }
    private BicepValue<bool>? _enableHttpsTrafficOnly;

    /// <summary>
    /// Encryption settings to be used for server-side encryption for the
    /// storage account.
    /// </summary>
    public StorageAccountEncryption Encryption 
    {
        get { Initialize(); return _encryption!; }
        set { Initialize(); AssignOrReplace(ref _encryption, value); }
    }
    private StorageAccountEncryption? _encryption;

    /// <summary>
    /// Optional. Set the extended location of the resource. If not set, the
    /// storage account will be created in Azure main region. Otherwise it
    /// will be created in the specified extended location.
    /// </summary>
    public ExtendedAzureLocation ExtendedLocation 
    {
        get { Initialize(); return _extendedLocation!; }
        set { Initialize(); AssignOrReplace(ref _extendedLocation, value); }
    }
    private ExtendedAzureLocation? _extendedLocation;

    /// <summary>
    /// The identity of the resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The property is immutable and can only be set to true at the account
    /// creation time. When set to true, it enables object level immutability
    /// for all the new containers in the account by default.
    /// </summary>
    public ImmutableStorageAccount ImmutableStorageWithVersioning 
    {
        get { Initialize(); return _immutableStorageWithVersioning!; }
        set { Initialize(); AssignOrReplace(ref _immutableStorageWithVersioning, value); }
    }
    private ImmutableStorageAccount? _immutableStorageWithVersioning;

    /// <summary>
    /// A boolean flag which indicates whether the default authentication is
    /// OAuth or not. The default interpretation is false for this property.
    /// </summary>
    public BicepValue<bool> IsDefaultToOAuthAuthentication 
    {
        get { Initialize(); return _isDefaultToOAuthAuthentication!; }
        set { Initialize(); _isDefaultToOAuthAuthentication!.Assign(value); }
    }
    private BicepValue<bool>? _isDefaultToOAuthAuthentication;

    /// <summary>
    /// Account HierarchicalNamespace enabled if sets to true.
    /// </summary>
    public BicepValue<bool> IsHnsEnabled 
    {
        get { Initialize(); return _isHnsEnabled!; }
        set { Initialize(); _isHnsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isHnsEnabled;

    /// <summary>
    /// Enables local users feature, if set to true.
    /// </summary>
    public BicepValue<bool> IsLocalUserEnabled 
    {
        get { Initialize(); return _isLocalUserEnabled!; }
        set { Initialize(); _isLocalUserEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalUserEnabled;

    /// <summary>
    /// NFS 3.0 protocol support enabled if set to true.
    /// </summary>
    public BicepValue<bool> IsNfsV3Enabled 
    {
        get { Initialize(); return _isNfsV3Enabled!; }
        set { Initialize(); _isNfsV3Enabled!.Assign(value); }
    }
    private BicepValue<bool>? _isNfsV3Enabled;

    /// <summary>
    /// Enables Secure File Transfer Protocol, if set to true.
    /// </summary>
    public BicepValue<bool> IsSftpEnabled 
    {
        get { Initialize(); return _isSftpEnabled!; }
        set { Initialize(); _isSftpEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isSftpEnabled;

    /// <summary>
    /// The key expiration period in days.
    /// </summary>
    public BicepValue<int> KeyExpirationPeriodInDays 
    {
        get { Initialize(); return _keyExpirationPeriodInDays!; }
        set { Initialize(); _keyExpirationPeriodInDays!.Assign(value); }
    }
    private BicepValue<int>? _keyExpirationPeriodInDays;

    /// <summary>
    /// Allow large file shares if sets to Enabled. It cannot be disabled once
    /// it is enabled.
    /// </summary>
    public BicepValue<LargeFileSharesState> LargeFileSharesState 
    {
        get { Initialize(); return _largeFileSharesState!; }
        set { Initialize(); _largeFileSharesState!.Assign(value); }
    }
    private BicepValue<LargeFileSharesState>? _largeFileSharesState;

    /// <summary>
    /// Set the minimum TLS version to be permitted on requests to storage. The
    /// default interpretation is TLS 1.0 for this property.
    /// </summary>
    public BicepValue<StorageMinimumTlsVersion> MinimumTlsVersion 
    {
        get { Initialize(); return _minimumTlsVersion!; }
        set { Initialize(); _minimumTlsVersion!.Assign(value); }
    }
    private BicepValue<StorageMinimumTlsVersion>? _minimumTlsVersion;

    /// <summary>
    /// Network rule set.
    /// </summary>
    public StorageAccountNetworkRuleSet NetworkRuleSet 
    {
        get { Initialize(); return _networkRuleSet!; }
        set { Initialize(); AssignOrReplace(ref _networkRuleSet, value); }
    }
    private StorageAccountNetworkRuleSet? _networkRuleSet;

    /// <summary>
    /// Allow or disallow public network access to Storage Account. Value is
    /// optional but if passed in, must be &apos;Enabled&apos; or
    /// &apos;Disabled&apos;.
    /// </summary>
    public BicepValue<StoragePublicNetworkAccess> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<StoragePublicNetworkAccess>? _publicNetworkAccess;

    /// <summary>
    /// Maintains information about the network routing choice opted by the
    /// user for data transfer.
    /// </summary>
    public StorageRoutingPreference RoutingPreference 
    {
        get { Initialize(); return _routingPreference!; }
        set { Initialize(); AssignOrReplace(ref _routingPreference, value); }
    }
    private StorageRoutingPreference? _routingPreference;

    /// <summary>
    /// SasPolicy assigned to the storage account.
    /// </summary>
    public StorageAccountSasPolicy SasPolicy 
    {
        get { Initialize(); return _sasPolicy!; }
        set { Initialize(); AssignOrReplace(ref _sasPolicy, value); }
    }
    private StorageAccountSasPolicy? _sasPolicy;

    /// <summary>
    /// Gets or sets a list of key value pairs that describe the resource.
    /// These tags can be used for viewing and grouping this resource (across
    /// resource groups). A maximum of 15 tags can be provided for a resource.
    /// Each tag must have a key with a length no greater than 128 characters
    /// and a value with a length no greater than 256 characters.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Blob restore status.
    /// </summary>
    public BlobRestoreStatus BlobRestoreStatus 
    {
        get { Initialize(); return _blobRestoreStatus!; }
    }
    private BlobRestoreStatus? _blobRestoreStatus;

    /// <summary>
    /// Gets the creation date and time of the storage account in UTC.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Geo Replication Stats.
    /// </summary>
    public GeoReplicationStatistics GeoReplicationStats 
    {
        get { Initialize(); return _geoReplicationStats!; }
    }
    private GeoReplicationStatistics? _geoReplicationStats;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// If the failover is in progress, the value will be true, otherwise, it
    /// will be null.
    /// </summary>
    public BicepValue<bool> IsFailoverInProgress 
    {
        get { Initialize(); return _isFailoverInProgress!; }
    }
    private BicepValue<bool>? _isFailoverInProgress;

    /// <summary>
    /// Storage account keys creation time.
    /// </summary>
    public StorageAccountKeyCreationTime KeyCreationTime 
    {
        get { Initialize(); return _keyCreationTime!; }
    }
    private StorageAccountKeyCreationTime? _keyCreationTime;

    /// <summary>
    /// Gets the timestamp of the most recent instance of a failover to the
    /// secondary location. Only the most recent timestamp is retained. This
    /// element is not returned if there has never been a failover instance.
    /// Only available if the accountType is Standard_GRS or Standard_RAGRS.
    /// </summary>
    public BicepValue<DateTimeOffset> LastGeoFailoverOn 
    {
        get { Initialize(); return _lastGeoFailoverOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastGeoFailoverOn;

    /// <summary>
    /// Gets the URLs that are used to perform a retrieval of a public blob,
    /// queue, or table object. Note that Standard_ZRS and Premium_LRS
    /// accounts only return the blob endpoint.
    /// </summary>
    public StorageAccountEndpoints PrimaryEndpoints 
    {
        get { Initialize(); return _primaryEndpoints!; }
    }
    private StorageAccountEndpoints? _primaryEndpoints;

    /// <summary>
    /// Gets the location of the primary data center for the storage account.
    /// </summary>
    public BicepValue<AzureLocation> PrimaryLocation 
    {
        get { Initialize(); return _primaryLocation!; }
    }
    private BicepValue<AzureLocation>? _primaryLocation;

    /// <summary>
    /// List of private endpoint connection associated with the specified
    /// storage account.
    /// </summary>
    public BicepList<StoragePrivateEndpointConnectionData> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<StoragePrivateEndpointConnectionData>? _privateEndpointConnections;

    /// <summary>
    /// Gets the status of the storage account at the time the operation was
    /// called.
    /// </summary>
    public BicepValue<StorageProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<StorageProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the URLs that are used to perform a retrieval of a public blob,
    /// queue, or table object from the secondary location of the storage
    /// account. Only available if the SKU name is Standard_RAGRS.
    /// </summary>
    public StorageAccountEndpoints SecondaryEndpoints 
    {
        get { Initialize(); return _secondaryEndpoints!; }
    }
    private StorageAccountEndpoints? _secondaryEndpoints;

    /// <summary>
    /// Gets the location of the geo-replicated secondary for the storage
    /// account. Only available if the accountType is Standard_GRS or
    /// Standard_RAGRS.
    /// </summary>
    public BicepValue<AzureLocation> SecondaryLocation 
    {
        get { Initialize(); return _secondaryLocation!; }
    }
    private BicepValue<AzureLocation>? _secondaryLocation;

    /// <summary>
    /// Gets the status indicating whether the primary location of the storage
    /// account is available or unavailable.
    /// </summary>
    public BicepValue<StorageAccountStatus> StatusOfPrimary 
    {
        get { Initialize(); return _statusOfPrimary!; }
    }
    private BicepValue<StorageAccountStatus>? _statusOfPrimary;

    /// <summary>
    /// Gets the status indicating whether the secondary location of the
    /// storage account is available or unavailable. Only available if the SKU
    /// name is Standard_GRS or Standard_RAGRS.
    /// </summary>
    public BicepValue<StorageAccountStatus> StatusOfSecondary 
    {
        get { Initialize(); return _statusOfSecondary!; }
    }
    private BicepValue<StorageAccountStatus>? _statusOfSecondary;

    /// <summary>
    /// This property is readOnly and is set by server during asynchronous
    /// storage account sku conversion operations.
    /// </summary>
    public StorageAccountSkuConversionStatus StorageAccountSkuConversionStatus 
    {
        get { Initialize(); return _storageAccountSkuConversionStatus!; }
    }
    private StorageAccountSkuConversionStatus? _storageAccountSkuConversionStatus;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new StorageAccount.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StorageAccount resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StorageAccount.</param>
    public StorageAccount(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Storage/storageAccounts", resourceVersion ?? "2024-01-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccount.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _kind = DefineProperty<StorageKind>("Kind", ["kind"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _sku = DefineModelProperty<StorageSku>("Sku", ["sku"], isRequired: true);
        _accessTier = DefineProperty<StorageAccountAccessTier>("AccessTier", ["properties", "accessTier"]);
        _allowBlobPublicAccess = DefineProperty<bool>("AllowBlobPublicAccess", ["properties", "allowBlobPublicAccess"]);
        _allowCrossTenantReplication = DefineProperty<bool>("AllowCrossTenantReplication", ["properties", "allowCrossTenantReplication"]);
        _allowedCopyScope = DefineProperty<AllowedCopyScope>("AllowedCopyScope", ["properties", "allowedCopyScope"]);
        _allowSharedKeyAccess = DefineProperty<bool>("AllowSharedKeyAccess", ["properties", "allowSharedKeyAccess"]);
        _azureFilesIdentityBasedAuthentication = DefineModelProperty<FilesIdentityBasedAuthentication>("AzureFilesIdentityBasedAuthentication", ["properties", "azureFilesIdentityBasedAuthentication"]);
        _customDomain = DefineModelProperty<StorageCustomDomain>("CustomDomain", ["properties", "customDomain"]);
        _dnsEndpointType = DefineProperty<StorageDnsEndpointType>("DnsEndpointType", ["properties", "dnsEndpointType"]);
        _enableHttpsTrafficOnly = DefineProperty<bool>("EnableHttpsTrafficOnly", ["properties", "supportsHttpsTrafficOnly"]);
        _encryption = DefineModelProperty<StorageAccountEncryption>("Encryption", ["properties", "encryption"]);
        _extendedLocation = DefineModelProperty<ExtendedAzureLocation>("ExtendedLocation", ["extendedLocation"]);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _immutableStorageWithVersioning = DefineModelProperty<ImmutableStorageAccount>("ImmutableStorageWithVersioning", ["properties", "immutableStorageWithVersioning"]);
        _isDefaultToOAuthAuthentication = DefineProperty<bool>("IsDefaultToOAuthAuthentication", ["properties", "defaultToOAuthAuthentication"]);
        _isHnsEnabled = DefineProperty<bool>("IsHnsEnabled", ["properties", "isHnsEnabled"]);
        _isLocalUserEnabled = DefineProperty<bool>("IsLocalUserEnabled", ["properties", "isLocalUserEnabled"]);
        _isNfsV3Enabled = DefineProperty<bool>("IsNfsV3Enabled", ["properties", "isNfsV3Enabled"]);
        _isSftpEnabled = DefineProperty<bool>("IsSftpEnabled", ["properties", "isSftpEnabled"]);
        _keyExpirationPeriodInDays = DefineProperty<int>("KeyExpirationPeriodInDays", ["properties", "keyPolicy", "keyExpirationPeriodInDays"]);
        _largeFileSharesState = DefineProperty<LargeFileSharesState>("LargeFileSharesState", ["properties", "largeFileSharesState"]);
        _minimumTlsVersion = DefineProperty<StorageMinimumTlsVersion>("MinimumTlsVersion", ["properties", "minimumTlsVersion"]);
        _networkRuleSet = DefineModelProperty<StorageAccountNetworkRuleSet>("NetworkRuleSet", ["properties", "networkAcls"]);
        _publicNetworkAccess = DefineProperty<StoragePublicNetworkAccess>("PublicNetworkAccess", ["properties", "publicNetworkAccess"]);
        _routingPreference = DefineModelProperty<StorageRoutingPreference>("RoutingPreference", ["properties", "routingPreference"]);
        _sasPolicy = DefineModelProperty<StorageAccountSasPolicy>("SasPolicy", ["properties", "sasPolicy"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _blobRestoreStatus = DefineModelProperty<BlobRestoreStatus>("BlobRestoreStatus", ["properties", "blobRestoreStatus"], isOutput: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "creationTime"], isOutput: true);
        _geoReplicationStats = DefineModelProperty<GeoReplicationStatistics>("GeoReplicationStats", ["properties", "geoReplicationStats"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _isFailoverInProgress = DefineProperty<bool>("IsFailoverInProgress", ["properties", "failoverInProgress"], isOutput: true);
        _keyCreationTime = DefineModelProperty<StorageAccountKeyCreationTime>("KeyCreationTime", ["properties", "keyCreationTime"], isOutput: true);
        _lastGeoFailoverOn = DefineProperty<DateTimeOffset>("LastGeoFailoverOn", ["properties", "lastGeoFailoverTime"], isOutput: true);
        _primaryEndpoints = DefineModelProperty<StorageAccountEndpoints>("PrimaryEndpoints", ["properties", "primaryEndpoints"], isOutput: true);
        _primaryLocation = DefineProperty<AzureLocation>("PrimaryLocation", ["properties", "primaryLocation"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<StoragePrivateEndpointConnectionData>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _provisioningState = DefineProperty<StorageProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _secondaryEndpoints = DefineModelProperty<StorageAccountEndpoints>("SecondaryEndpoints", ["properties", "secondaryEndpoints"], isOutput: true);
        _secondaryLocation = DefineProperty<AzureLocation>("SecondaryLocation", ["properties", "secondaryLocation"], isOutput: true);
        _statusOfPrimary = DefineProperty<StorageAccountStatus>("StatusOfPrimary", ["properties", "statusOfPrimary"], isOutput: true);
        _statusOfSecondary = DefineProperty<StorageAccountStatus>("StatusOfSecondary", ["properties", "statusOfSecondary"], isOutput: true);
        _storageAccountSkuConversionStatus = DefineModelProperty<StorageAccountSkuConversionStatus>("StorageAccountSkuConversionStatus", ["properties", "storageAccountSkuConversionStatus"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported StorageAccount resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-01-01.
        /// </summary>
        public static readonly string V2024_01_01 = "2024-01-01";

        /// <summary>
        /// 2023-05-01.
        /// </summary>
        public static readonly string V2023_05_01 = "2023-05-01";

        /// <summary>
        /// 2023-04-01.
        /// </summary>
        public static readonly string V2023_04_01 = "2023-04-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-05-01.
        /// </summary>
        public static readonly string V2022_05_01 = "2022-05-01";

        /// <summary>
        /// 2021-09-01.
        /// </summary>
        public static readonly string V2021_09_01 = "2021-09-01";

        /// <summary>
        /// 2021-08-01.
        /// </summary>
        public static readonly string V2021_08_01 = "2021-08-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2021-05-01.
        /// </summary>
        public static readonly string V2021_05_01 = "2021-05-01";

        /// <summary>
        /// 2021-04-01.
        /// </summary>
        public static readonly string V2021_04_01 = "2021-04-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2019-06-01.
        /// </summary>
        public static readonly string V2019_06_01 = "2019-06-01";

        /// <summary>
        /// 2019-04-01.
        /// </summary>
        public static readonly string V2019_04_01 = "2019-04-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-07-01.
        /// </summary>
        public static readonly string V2018_07_01 = "2018-07-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-10-01.
        /// </summary>
        public static readonly string V2017_10_01 = "2017-10-01";

        /// <summary>
        /// 2017-06-01.
        /// </summary>
        public static readonly string V2017_06_01 = "2017-06-01";

        /// <summary>
        /// 2016-12-01.
        /// </summary>
        public static readonly string V2016_12_01 = "2016-12-01";

        /// <summary>
        /// 2016-05-01.
        /// </summary>
        public static readonly string V2016_05_01 = "2016-05-01";

        /// <summary>
        /// 2016-01-01.
        /// </summary>
        public static readonly string V2016_01_01 = "2016-01-01";

        /// <summary>
        /// 2015-06-15.
        /// </summary>
        public static readonly string V2015_06_15 = "2015-06-15";
    }

    /// <summary>
    /// Creates a reference to an existing StorageAccount.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StorageAccount resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StorageAccount.</param>
    /// <returns>The existing StorageAccount resource.</returns>
    public static StorageAccount FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this StorageAccount resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 24, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers);

    /// <summary>
    /// Get access keys for this StorageAccount resource.
    /// </summary>
    /// <returns>The keys for this StorageAccount resource.</returns>
    public BicepList<StorageAccountKey> GetKeys()
    {
        return BicepList<StorageAccountKey>.FromExpression(
            e => { StorageAccountKey key = new(); ((IBicepValue)key).Expression = e; return key; },
            new MemberExpression(new FunctionCallExpression(new MemberExpression(new IdentifierExpression(BicepIdentifier), "listKeys")), "keys"));
    }

    /// <summary>
    /// Creates a role assignment for a user-assigned identity that grants
    /// access to this StorageAccount.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="identity">The <see cref="UserAssignedIdentity"/>.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(StorageBuiltInRole role, UserAssignedIdentity identity) =>
        new($"{BicepIdentifier}_{identity.BicepIdentifier}_{StorageBuiltInRole.GetBuiltInRoleName(role)}")
        {
            Name = BicepFunction.CreateGuid(Id, identity.PrincipalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = RoleManagementPrincipalType.ServicePrincipal,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = identity.PrincipalId
        };

    /// <summary>
    /// Creates a role assignment for a principal that grants access to this
    /// StorageAccount.
    /// </summary>
    /// <param name="role">The role to grant.</param>
    /// <param name="principalType">The type of the principal to assign to.</param>
    /// <param name="principalId">The principal to assign to.</param>
    /// <param name="bicepIdentifierSuffix">Optional role assignment identifier name suffix.</param>
    /// <returns>The <see cref="RoleAssignment"/>.</returns>
    public RoleAssignment CreateRoleAssignment(StorageBuiltInRole role, BicepValue<RoleManagementPrincipalType> principalType, BicepValue<Guid> principalId, string? bicepIdentifierSuffix = default) =>
        new($"{BicepIdentifier}_{StorageBuiltInRole.GetBuiltInRoleName(role)}{(bicepIdentifierSuffix is null ? "" : "_")}{bicepIdentifierSuffix}")
        {
            Name = BicepFunction.CreateGuid(Id, principalId, BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString())),
            Scope = new IdentifierExpression(BicepIdentifier),
            PrincipalType = principalType,
            RoleDefinitionId = BicepFunction.GetSubscriptionResourceId("Microsoft.Authorization/roleDefinitions", role.ToString()),
            PrincipalId = principalId
        };
}
