// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// An update history of the ImmutabilityPolicy of a blob container.
/// </summary>
public partial class UpdateHistoryEntry : ProvisionableConstruct
{
    /// <summary>
    /// The ImmutabilityPolicy update type of a blob container, possible values
    /// include: put, lock and extend.
    /// </summary>
    public BicepValue<ImmutabilityPolicyUpdateType> UpdateType 
    {
        get { Initialize(); return _updateType!; }
    }
    private BicepValue<ImmutabilityPolicyUpdateType>? _updateType;

    /// <summary>
    /// The immutability period for the blobs in the container since the policy
    /// creation, in days.
    /// </summary>
    public BicepValue<int> ImmutabilityPeriodSinceCreationInDays 
    {
        get { Initialize(); return _immutabilityPeriodSinceCreationInDays!; }
    }
    private BicepValue<int>? _immutabilityPeriodSinceCreationInDays;

    /// <summary>
    /// Returns the date and time the ImmutabilityPolicy was updated.
    /// </summary>
    public BicepValue<DateTimeOffset> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<DateTimeOffset>? _timestamp;

    /// <summary>
    /// Returns the Object ID of the user who updated the ImmutabilityPolicy.
    /// </summary>
    public BicepValue<string> ObjectIdentifier 
    {
        get { Initialize(); return _objectIdentifier!; }
    }
    private BicepValue<string>? _objectIdentifier;

    /// <summary>
    /// Returns the Tenant ID that issued the token for the user who updated
    /// the ImmutabilityPolicy.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Returns the User Principal Name of the user who updated the
    /// ImmutabilityPolicy.
    /// </summary>
    public BicepValue<string> Upn 
    {
        get { Initialize(); return _upn!; }
    }
    private BicepValue<string>? _upn;

    /// <summary>
    /// This property can only be changed for unlocked time-based retention
    /// policies. When enabled, new blocks can be written to an append blob
    /// while maintaining immutability protection and compliance. Only new
    /// blocks can be added and any existing blocks cannot be modified or
    /// deleted. This property cannot be changed with ExtendImmutabilityPolicy
    /// API.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWrites 
    {
        get { Initialize(); return _allowProtectedAppendWrites!; }
    }
    private BicepValue<bool>? _allowProtectedAppendWrites;

    /// <summary>
    /// This property can only be changed for unlocked time-based retention
    /// policies. When enabled, new blocks can be written to both &apos;Append
    /// and Bock Blobs&apos; while maintaining immutability protection and
    /// compliance. Only new blocks can be added and any existing blocks
    /// cannot be modified or deleted. This property cannot be changed with
    /// ExtendImmutabilityPolicy API. The
    /// &apos;allowProtectedAppendWrites&apos; and
    /// &apos;allowProtectedAppendWritesAll&apos; properties are mutually
    /// exclusive.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWritesAll 
    {
        get { Initialize(); return _allowProtectedAppendWritesAll!; }
    }
    private BicepValue<bool>? _allowProtectedAppendWritesAll;

    /// <summary>
    /// Creates a new UpdateHistoryEntry.
    /// </summary>
    public UpdateHistoryEntry()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of UpdateHistoryEntry.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _updateType = DefineProperty<ImmutabilityPolicyUpdateType>("UpdateType", ["update"], isOutput: true);
        _immutabilityPeriodSinceCreationInDays = DefineProperty<int>("ImmutabilityPeriodSinceCreationInDays", ["immutabilityPeriodSinceCreationInDays"], isOutput: true);
        _timestamp = DefineProperty<DateTimeOffset>("Timestamp", ["timestamp"], isOutput: true);
        _objectIdentifier = DefineProperty<string>("ObjectIdentifier", ["objectIdentifier"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _upn = DefineProperty<string>("Upn", ["upn"], isOutput: true);
        _allowProtectedAppendWrites = DefineProperty<bool>("AllowProtectedAppendWrites", ["allowProtectedAppendWrites"], isOutput: true);
        _allowProtectedAppendWritesAll = DefineProperty<bool>("AllowProtectedAppendWritesAll", ["allowProtectedAppendWritesAll"], isOutput: true);
    }
}
