// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Object to set Table Access Policy.
/// </summary>
public partial class StorageTableSignedIdentifier : ProvisionableConstruct
{
    /// <summary>
    /// unique-64-character-value of the stored access policy.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// Access policy.
    /// </summary>
    public StorageTableAccessPolicy AccessPolicy 
    {
        get { Initialize(); return _accessPolicy!; }
        set { Initialize(); AssignOrReplace(ref _accessPolicy, value); }
    }
    private StorageTableAccessPolicy? _accessPolicy;

    /// <summary>
    /// Creates a new StorageTableSignedIdentifier.
    /// </summary>
    public StorageTableSignedIdentifier()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageTableSignedIdentifier.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _accessPolicy = DefineModelProperty<StorageTableAccessPolicy>("AccessPolicy", ["accessPolicy"]);
    }
}
