// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Table Access Policy Properties Object.
/// </summary>
public partial class StorageTableAccessPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Start time of the access policy.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Expiry time of the access policy.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
        set { Initialize(); _expireOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// Required. List of abbreviated permissions. Supported permission values
    /// include &apos;r&apos;,&apos;a&apos;,&apos;u&apos;,&apos;d&apos;.
    /// </summary>
    public BicepValue<string> Permission 
    {
        get { Initialize(); return _permission!; }
        set { Initialize(); _permission!.Assign(value); }
    }
    private BicepValue<string>? _permission;

    /// <summary>
    /// Creates a new StorageTableAccessPolicy.
    /// </summary>
    public StorageTableAccessPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageTableAccessPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startTime"]);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["expiryTime"]);
        _permission = DefineProperty<string>("Permission", ["permission"]);
    }
}
