// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The SKU of the storage account.
/// </summary>
public partial class StorageSku : ProvisionableConstruct
{
    /// <summary>
    /// The SKU name. Required for account creation; optional for update. Note
    /// that in older versions, SKU name was called accountType.
    /// </summary>
    public BicepValue<StorageSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<StorageSkuName>? _name;

    /// <summary>
    /// The SKU tier. This is based on the SKU name.
    /// </summary>
    public BicepValue<StorageSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
    }
    private BicepValue<StorageSkuTier>? _tier;

    /// <summary>
    /// Creates a new StorageSku.
    /// </summary>
    public StorageSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<StorageSkuName>("Name", ["name"]);
        _tier = DefineProperty<StorageSkuTier>("Tier", ["tier"], isOutput: true);
    }
}
