// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The StorageSignedIdentifier.
/// </summary>
public partial class StorageSignedIdentifier : ProvisionableConstruct
{
    /// <summary>
    /// An unique identifier of the stored access policy.
    /// </summary>
    public BicepValue<string> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<string>? _id;

    /// <summary>
    /// Access policy.
    /// </summary>
    public StorageServiceAccessPolicy AccessPolicy 
    {
        get { Initialize(); return _accessPolicy!; }
        set { Initialize(); AssignOrReplace(ref _accessPolicy, value); }
    }
    private StorageServiceAccessPolicy? _accessPolicy;

    /// <summary>
    /// Creates a new StorageSignedIdentifier.
    /// </summary>
    public StorageSignedIdentifier()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageSignedIdentifier.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<string>("Id", ["id"]);
        _accessPolicy = DefineModelProperty<StorageServiceAccessPolicy>("AccessPolicy", ["accessPolicy"]);
    }
}
