// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The StorageServiceAccessPolicy.
/// </summary>
public partial class StorageServiceAccessPolicy : ProvisionableConstruct
{
    /// <summary>
    /// Start time of the access policy.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
        set { Initialize(); _startOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// Expiry time of the access policy.
    /// </summary>
    public BicepValue<DateTimeOffset> ExpireOn 
    {
        get { Initialize(); return _expireOn!; }
        set { Initialize(); _expireOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _expireOn;

    /// <summary>
    /// List of abbreviated permissions.
    /// </summary>
    public BicepValue<string> Permission 
    {
        get { Initialize(); return _permission!; }
        set { Initialize(); _permission!.Assign(value); }
    }
    private BicepValue<string>? _permission;

    /// <summary>
    /// Creates a new StorageServiceAccessPolicy.
    /// </summary>
    public StorageServiceAccessPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageServiceAccessPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startTime"]);
        _expireOn = DefineProperty<DateTimeOffset>("ExpireOn", ["expiryTime"]);
        _permission = DefineProperty<string>("Permission", ["permission"]);
    }
}
