// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The StoragePermissionScope.
/// </summary>
public partial class StoragePermissionScope : ProvisionableConstruct
{
    /// <summary>
    /// The permissions for the local user. Possible values include: Read (r),
    /// Write (w), Delete (d), List (l), and Create (c).
    /// </summary>
    public BicepValue<string> Permissions 
    {
        get { Initialize(); return _permissions!; }
        set { Initialize(); _permissions!.Assign(value); }
    }
    private BicepValue<string>? _permissions;

    /// <summary>
    /// The service used by the local user, e.g. blob, file.
    /// </summary>
    public BicepValue<string> Service 
    {
        get { Initialize(); return _service!; }
        set { Initialize(); _service!.Assign(value); }
    }
    private BicepValue<string>? _service;

    /// <summary>
    /// The name of resource, normally the container name or the file share
    /// name, used by the local user.
    /// </summary>
    public BicepValue<string> ResourceName 
    {
        get { Initialize(); return _resourceName!; }
        set { Initialize(); _resourceName!.Assign(value); }
    }
    private BicepValue<string>? _resourceName;

    /// <summary>
    /// Creates a new StoragePermissionScope.
    /// </summary>
    public StoragePermissionScope()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StoragePermissionScope.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _permissions = DefineProperty<string>("Permissions", ["permissions"]);
        _service = DefineProperty<string>("Service", ["service"]);
        _resourceName = DefineProperty<string>("ResourceName", ["resourceName"]);
    }
}
