// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// A service that allows server-side encryption to be used.
/// </summary>
public partial class StorageEncryptionService : ProvisionableConstruct
{
    /// <summary>
    /// A boolean indicating whether or not the service encrypts the data as it
    /// is stored. Encryption at rest is enabled by default today and cannot
    /// be disabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Gets a rough estimate of the date/time when the encryption was last
    /// enabled by the user. Data is encrypted at rest by default today and
    /// cannot be disabled.
    /// </summary>
    public BicepValue<DateTimeOffset> LastEnabledOn 
    {
        get { Initialize(); return _lastEnabledOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastEnabledOn;

    /// <summary>
    /// Encryption key type to be used for the encryption service.
    /// &apos;Account&apos; key type implies that an account-scoped encryption
    /// key will be used. &apos;Service&apos; key type implies that a default
    /// service key is used.
    /// </summary>
    public BicepValue<StorageEncryptionKeyType> KeyType 
    {
        get { Initialize(); return _keyType!; }
        set { Initialize(); _keyType!.Assign(value); }
    }
    private BicepValue<StorageEncryptionKeyType>? _keyType;

    /// <summary>
    /// Creates a new StorageEncryptionService.
    /// </summary>
    public StorageEncryptionService()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageEncryptionService.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _lastEnabledOn = DefineProperty<DateTimeOffset>("LastEnabledOn", ["lastEnabledTime"], isOutput: true);
        _keyType = DefineProperty<StorageEncryptionKeyType>("KeyType", ["keyType"]);
    }
}
