// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The custom domain assigned to this storage account. This can be set via
/// Update.
/// </summary>
public partial class StorageCustomDomain : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the custom domain name assigned to the storage account.
    /// Name is the CNAME source.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Indicates whether indirect CName validation is enabled. Default value
    /// is false. This should only be set on updates.
    /// </summary>
    public BicepValue<bool> IsUseSubDomainNameEnabled 
    {
        get { Initialize(); return _isUseSubDomainNameEnabled!; }
        set { Initialize(); _isUseSubDomainNameEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isUseSubDomainNameEnabled;

    /// <summary>
    /// Creates a new StorageCustomDomain.
    /// </summary>
    public StorageCustomDomain()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageCustomDomain.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _isUseSubDomainNameEnabled = DefineProperty<bool>("IsUseSubDomainNameEnabled", ["useSubDomainName"]);
    }
}
