// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Specifies a CORS rule for the Blob service.
/// </summary>
public partial class StorageCorsRule : ProvisionableConstruct
{
    /// <summary>
    /// Required if CorsRule element is present. A list of origin domains that
    /// will be allowed via CORS, or &quot;*&quot; to allow all domains.
    /// </summary>
    public BicepList<string> AllowedOrigins 
    {
        get { Initialize(); return _allowedOrigins!; }
        set { Initialize(); _allowedOrigins!.Assign(value); }
    }
    private BicepList<string>? _allowedOrigins;

    /// <summary>
    /// Required if CorsRule element is present. A list of HTTP methods that
    /// are allowed to be executed by the origin.
    /// </summary>
    public BicepList<CorsRuleAllowedMethod> AllowedMethods 
    {
        get { Initialize(); return _allowedMethods!; }
        set { Initialize(); _allowedMethods!.Assign(value); }
    }
    private BicepList<CorsRuleAllowedMethod>? _allowedMethods;

    /// <summary>
    /// Required if CorsRule element is present. The number of seconds that the
    /// client/browser should cache a preflight response.
    /// </summary>
    public BicepValue<int> MaxAgeInSeconds 
    {
        get { Initialize(); return _maxAgeInSeconds!; }
        set { Initialize(); _maxAgeInSeconds!.Assign(value); }
    }
    private BicepValue<int>? _maxAgeInSeconds;

    /// <summary>
    /// Required if CorsRule element is present. A list of response headers to
    /// expose to CORS clients.
    /// </summary>
    public BicepList<string> ExposedHeaders 
    {
        get { Initialize(); return _exposedHeaders!; }
        set { Initialize(); _exposedHeaders!.Assign(value); }
    }
    private BicepList<string>? _exposedHeaders;

    /// <summary>
    /// Required if CorsRule element is present. A list of headers allowed to
    /// be part of the cross-origin request.
    /// </summary>
    public BicepList<string> AllowedHeaders 
    {
        get { Initialize(); return _allowedHeaders!; }
        set { Initialize(); _allowedHeaders!.Assign(value); }
    }
    private BicepList<string>? _allowedHeaders;

    /// <summary>
    /// Creates a new StorageCorsRule.
    /// </summary>
    public StorageCorsRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageCorsRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowedOrigins = DefineListProperty<string>("AllowedOrigins", ["allowedOrigins"]);
        _allowedMethods = DefineListProperty<CorsRuleAllowedMethod>("AllowedMethods", ["allowedMethods"]);
        _maxAgeInSeconds = DefineProperty<int>("MaxAgeInSeconds", ["maxAgeInSeconds"]);
        _exposedHeaders = DefineListProperty<string>("ExposedHeaders", ["exposedHeaders"]);
        _allowedHeaders = DefineListProperty<string>("AllowedHeaders", ["allowedHeaders"]);
    }
}
