// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Settings properties for Active Directory (AD).
/// </summary>
public partial class StorageActiveDirectoryProperties : ProvisionableConstruct
{
    /// <summary>
    /// Specifies the primary domain that the AD DNS server is authoritative
    /// for.
    /// </summary>
    public BicepValue<string> DomainName 
    {
        get { Initialize(); return _domainName!; }
        set { Initialize(); _domainName!.Assign(value); }
    }
    private BicepValue<string>? _domainName;

    /// <summary>
    /// Specifies the NetBIOS domain name.
    /// </summary>
    public BicepValue<string> NetBiosDomainName 
    {
        get { Initialize(); return _netBiosDomainName!; }
        set { Initialize(); _netBiosDomainName!.Assign(value); }
    }
    private BicepValue<string>? _netBiosDomainName;

    /// <summary>
    /// Specifies the Active Directory forest to get.
    /// </summary>
    public BicepValue<string> ForestName 
    {
        get { Initialize(); return _forestName!; }
        set { Initialize(); _forestName!.Assign(value); }
    }
    private BicepValue<string>? _forestName;

    /// <summary>
    /// Specifies the domain GUID.
    /// </summary>
    public BicepValue<Guid> DomainGuid 
    {
        get { Initialize(); return _domainGuid!; }
        set { Initialize(); _domainGuid!.Assign(value); }
    }
    private BicepValue<Guid>? _domainGuid;

    /// <summary>
    /// Specifies the security identifier (SID).
    /// </summary>
    public BicepValue<string> DomainSid 
    {
        get { Initialize(); return _domainSid!; }
        set { Initialize(); _domainSid!.Assign(value); }
    }
    private BicepValue<string>? _domainSid;

    /// <summary>
    /// Specifies the security identifier (SID) for Azure Storage.
    /// </summary>
    public BicepValue<string> AzureStorageSid 
    {
        get { Initialize(); return _azureStorageSid!; }
        set { Initialize(); _azureStorageSid!.Assign(value); }
    }
    private BicepValue<string>? _azureStorageSid;

    /// <summary>
    /// Specifies the Active Directory SAMAccountName for Azure Storage.
    /// </summary>
    public BicepValue<string> SamAccountName 
    {
        get { Initialize(); return _samAccountName!; }
        set { Initialize(); _samAccountName!.Assign(value); }
    }
    private BicepValue<string>? _samAccountName;

    /// <summary>
    /// Specifies the Active Directory account type for Azure Storage.
    /// </summary>
    public BicepValue<ActiveDirectoryAccountType> AccountType 
    {
        get { Initialize(); return _accountType!; }
        set { Initialize(); _accountType!.Assign(value); }
    }
    private BicepValue<ActiveDirectoryAccountType>? _accountType;

    /// <summary>
    /// Creates a new StorageActiveDirectoryProperties.
    /// </summary>
    public StorageActiveDirectoryProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageActiveDirectoryProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _domainName = DefineProperty<string>("DomainName", ["domainName"]);
        _netBiosDomainName = DefineProperty<string>("NetBiosDomainName", ["netBiosDomainName"]);
        _forestName = DefineProperty<string>("ForestName", ["forestName"]);
        _domainGuid = DefineProperty<Guid>("DomainGuid", ["domainGuid"]);
        _domainSid = DefineProperty<string>("DomainSid", ["domainSid"]);
        _azureStorageSid = DefineProperty<string>("AzureStorageSid", ["azureStorageSid"]);
        _samAccountName = DefineProperty<string>("SamAccountName", ["samAccountName"]);
        _accountType = DefineProperty<ActiveDirectoryAccountType>("AccountType", ["accountType"]);
    }
}
