// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Virtual Network rule.
/// </summary>
public partial class StorageAccountVirtualNetworkRule : ProvisionableConstruct
{
    /// <summary>
    /// Resource ID of a subnet, for example:
    /// /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    /// </summary>
    public BicepValue<ResourceIdentifier> VirtualNetworkResourceId 
    {
        get { Initialize(); return _virtualNetworkResourceId!; }
        set { Initialize(); _virtualNetworkResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _virtualNetworkResourceId;

    /// <summary>
    /// The action of virtual network rule.
    /// </summary>
    public BicepValue<StorageAccountNetworkRuleAction> Action 
    {
        get { Initialize(); return _action!; }
        set { Initialize(); _action!.Assign(value); }
    }
    private BicepValue<StorageAccountNetworkRuleAction>? _action;

    /// <summary>
    /// Gets the state of virtual network rule.
    /// </summary>
    public BicepValue<StorageAccountNetworkRuleState> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<StorageAccountNetworkRuleState>? _state;

    /// <summary>
    /// Creates a new StorageAccountVirtualNetworkRule.
    /// </summary>
    public StorageAccountVirtualNetworkRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountVirtualNetworkRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _virtualNetworkResourceId = DefineProperty<ResourceIdentifier>("VirtualNetworkResourceId", ["id"]);
        _action = DefineProperty<StorageAccountNetworkRuleAction>("Action", ["action"]);
        _state = DefineProperty<StorageAccountNetworkRuleState>("State", ["state"]);
    }
}
