// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// This defines the sku conversion status object for asynchronous sku
/// conversions.
/// </summary>
public partial class StorageAccountSkuConversionStatus : ProvisionableConstruct
{
    /// <summary>
    /// This property indicates the current sku conversion status.
    /// </summary>
    public BicepValue<StorageAccountSkuConversionState> SkuConversionStatus 
    {
        get { Initialize(); return _skuConversionStatus!; }
    }
    private BicepValue<StorageAccountSkuConversionState>? _skuConversionStatus;

    /// <summary>
    /// This property represents the target sku name to which the account sku
    /// is being converted asynchronously.
    /// </summary>
    public BicepValue<StorageSkuName> TargetSkuName 
    {
        get { Initialize(); return _targetSkuName!; }
        set { Initialize(); _targetSkuName!.Assign(value); }
    }
    private BicepValue<StorageSkuName>? _targetSkuName;

    /// <summary>
    /// This property represents the sku conversion start time.
    /// </summary>
    public BicepValue<DateTimeOffset> StartOn 
    {
        get { Initialize(); return _startOn!; }
    }
    private BicepValue<DateTimeOffset>? _startOn;

    /// <summary>
    /// This property represents the sku conversion end time.
    /// </summary>
    public BicepValue<DateTimeOffset> EndOn 
    {
        get { Initialize(); return _endOn!; }
    }
    private BicepValue<DateTimeOffset>? _endOn;

    /// <summary>
    /// Creates a new StorageAccountSkuConversionStatus.
    /// </summary>
    public StorageAccountSkuConversionStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountSkuConversionStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _skuConversionStatus = DefineProperty<StorageAccountSkuConversionState>("SkuConversionStatus", ["skuConversionStatus"], isOutput: true);
        _targetSkuName = DefineProperty<StorageSkuName>("TargetSkuName", ["targetSkuName"]);
        _startOn = DefineProperty<DateTimeOffset>("StartOn", ["startTime"], isOutput: true);
        _endOn = DefineProperty<DateTimeOffset>("EndOn", ["endTime"], isOutput: true);
    }
}
