// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// SasPolicy assigned to the storage account.
/// </summary>
public partial class StorageAccountSasPolicy : ProvisionableConstruct
{
    /// <summary>
    /// The SAS expiration period, DD.HH:MM:SS.
    /// </summary>
    public BicepValue<string> SasExpirationPeriod 
    {
        get { Initialize(); return _sasExpirationPeriod!; }
        set { Initialize(); _sasExpirationPeriod!.Assign(value); }
    }
    private BicepValue<string>? _sasExpirationPeriod;

    /// <summary>
    /// The SAS expiration action. Can only be Log.
    /// </summary>
    public BicepValue<ExpirationAction> ExpirationAction 
    {
        get { Initialize(); return _expirationAction!; }
        set { Initialize(); _expirationAction!.Assign(value); }
    }
    private BicepValue<ExpirationAction>? _expirationAction;

    /// <summary>
    /// Creates a new StorageAccountSasPolicy.
    /// </summary>
    public StorageAccountSasPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccountSasPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sasExpirationPeriod = DefineProperty<string>("SasExpirationPeriod", ["sasExpirationPeriod"]);
        _expirationAction = DefineProperty<ExpirationAction>("ExpirationAction", ["expirationAction"]);
    }
}
