// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Resource Access Rule.
/// </summary>
public partial class StorageAccountResourceAccessRule : ProvisionableConstruct
{
    /// <summary>
    /// Tenant Id.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Resource Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// Creates a new StorageAccountResourceAccessRule.
    /// </summary>
    public StorageAccountResourceAccessRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountResourceAccessRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["resourceId"]);
    }
}
