// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Network rule set.
/// </summary>
public partial class StorageAccountNetworkRuleSet : ProvisionableConstruct
{
    /// <summary>
    /// Specifies whether traffic is bypassed for
    /// Logging/Metrics/AzureServices. Possible values are any combination of
    /// Logging|Metrics|AzureServices (For example, &quot;Logging,
    /// Metrics&quot;), or None to bypass none of those traffics.
    /// </summary>
    public BicepValue<StorageNetworkBypass> Bypass 
    {
        get { Initialize(); return _bypass!; }
        set { Initialize(); _bypass!.Assign(value); }
    }
    private BicepValue<StorageNetworkBypass>? _bypass;

    /// <summary>
    /// Sets the resource access rules.
    /// </summary>
    public BicepList<StorageAccountResourceAccessRule> ResourceAccessRules 
    {
        get { Initialize(); return _resourceAccessRules!; }
        set { Initialize(); _resourceAccessRules!.Assign(value); }
    }
    private BicepList<StorageAccountResourceAccessRule>? _resourceAccessRules;

    /// <summary>
    /// Sets the virtual network rules.
    /// </summary>
    public BicepList<StorageAccountVirtualNetworkRule> VirtualNetworkRules 
    {
        get { Initialize(); return _virtualNetworkRules!; }
        set { Initialize(); _virtualNetworkRules!.Assign(value); }
    }
    private BicepList<StorageAccountVirtualNetworkRule>? _virtualNetworkRules;

    /// <summary>
    /// Sets the IP ACL rules.
    /// </summary>
    public BicepList<StorageAccountIPRule> IPRules 
    {
        get { Initialize(); return _iPRules!; }
        set { Initialize(); _iPRules!.Assign(value); }
    }
    private BicepList<StorageAccountIPRule>? _iPRules;

    /// <summary>
    /// Specifies the default action of allow or deny when no other rules match.
    /// </summary>
    public BicepValue<StorageNetworkDefaultAction> DefaultAction 
    {
        get { Initialize(); return _defaultAction!; }
        set { Initialize(); _defaultAction!.Assign(value); }
    }
    private BicepValue<StorageNetworkDefaultAction>? _defaultAction;

    /// <summary>
    /// Creates a new StorageAccountNetworkRuleSet.
    /// </summary>
    public StorageAccountNetworkRuleSet()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccountNetworkRuleSet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _bypass = DefineProperty<StorageNetworkBypass>("Bypass", ["bypass"]);
        _resourceAccessRules = DefineListProperty<StorageAccountResourceAccessRule>("ResourceAccessRules", ["resourceAccessRules"]);
        _virtualNetworkRules = DefineListProperty<StorageAccountVirtualNetworkRule>("VirtualNetworkRules", ["virtualNetworkRules"]);
        _iPRules = DefineListProperty<StorageAccountIPRule>("IPRules", ["ipRules"]);
        _defaultAction = DefineProperty<StorageNetworkDefaultAction>("DefaultAction", ["defaultAction"]);
    }
}
