// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Properties of key vault.
/// </summary>
public partial class StorageAccountKeyVaultProperties : ProvisionableConstruct
{
    /// <summary>
    /// The name of KeyVault key.
    /// </summary>
    public BicepValue<string> KeyName 
    {
        get { Initialize(); return _keyName!; }
        set { Initialize(); _keyName!.Assign(value); }
    }
    private BicepValue<string>? _keyName;

    /// <summary>
    /// The version of KeyVault key.
    /// </summary>
    public BicepValue<string> KeyVersion 
    {
        get { Initialize(); return _keyVersion!; }
        set { Initialize(); _keyVersion!.Assign(value); }
    }
    private BicepValue<string>? _keyVersion;

    /// <summary>
    /// The Uri of KeyVault.
    /// </summary>
    public BicepValue<Uri> KeyVaultUri 
    {
        get { Initialize(); return _keyVaultUri!; }
        set { Initialize(); _keyVaultUri!.Assign(value); }
    }
    private BicepValue<Uri>? _keyVaultUri;

    /// <summary>
    /// The object identifier of the current versioned Key Vault Key in use.
    /// </summary>
    public BicepValue<string> CurrentVersionedKeyIdentifier 
    {
        get { Initialize(); return _currentVersionedKeyIdentifier!; }
    }
    private BicepValue<string>? _currentVersionedKeyIdentifier;

    /// <summary>
    /// Timestamp of last rotation of the Key Vault Key.
    /// </summary>
    public BicepValue<DateTimeOffset> LastKeyRotationTimestamp 
    {
        get { Initialize(); return _lastKeyRotationTimestamp!; }
    }
    private BicepValue<DateTimeOffset>? _lastKeyRotationTimestamp;

    /// <summary>
    /// This is a read only property that represents the expiration time of the
    /// current version of the customer managed key used for encryption.
    /// </summary>
    public BicepValue<DateTimeOffset> CurrentVersionedKeyExpirationTimestamp 
    {
        get { Initialize(); return _currentVersionedKeyExpirationTimestamp!; }
    }
    private BicepValue<DateTimeOffset>? _currentVersionedKeyExpirationTimestamp;

    /// <summary>
    /// Creates a new StorageAccountKeyVaultProperties.
    /// </summary>
    public StorageAccountKeyVaultProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountKeyVaultProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyName = DefineProperty<string>("KeyName", ["keyname"]);
        _keyVersion = DefineProperty<string>("KeyVersion", ["keyversion"]);
        _keyVaultUri = DefineProperty<Uri>("KeyVaultUri", ["keyvaulturi"]);
        _currentVersionedKeyIdentifier = DefineProperty<string>("CurrentVersionedKeyIdentifier", ["currentVersionedKeyIdentifier"], isOutput: true);
        _lastKeyRotationTimestamp = DefineProperty<DateTimeOffset>("LastKeyRotationTimestamp", ["lastKeyRotationTimestamp"], isOutput: true);
        _currentVersionedKeyExpirationTimestamp = DefineProperty<DateTimeOffset>("CurrentVersionedKeyExpirationTimestamp", ["currentVersionedKeyExpirationTimestamp"], isOutput: true);
    }
}
