// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Storage account keys creation time.
/// </summary>
public partial class StorageAccountKeyCreationTime : ProvisionableConstruct
{
    /// <summary>
    /// Gets the key 1.
    /// </summary>
    public BicepValue<DateTimeOffset> Key1 
    {
        get { Initialize(); return _key1!; }
    }
    private BicepValue<DateTimeOffset>? _key1;

    /// <summary>
    /// Gets the key 2.
    /// </summary>
    public BicepValue<DateTimeOffset> Key2 
    {
        get { Initialize(); return _key2!; }
    }
    private BicepValue<DateTimeOffset>? _key2;

    /// <summary>
    /// Creates a new StorageAccountKeyCreationTime.
    /// </summary>
    public StorageAccountKeyCreationTime()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountKeyCreationTime.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _key1 = DefineProperty<DateTimeOffset>("Key1", ["key1"], isOutput: true);
        _key2 = DefineProperty<DateTimeOffset>("Key2", ["key2"], isOutput: true);
    }
}
