// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Storage;

/// <summary>
/// An access key for the storage account.
/// </summary>
public partial class StorageAccountKey : ProvisionableConstruct
{
    /// <summary>
    /// Name of the key.
    /// </summary>
    public BicepValue<string> KeyName 
    {
        get { Initialize(); return _keyName!; }
    }
    private BicepValue<string>? _keyName;

    /// <summary>
    /// Base 64-encoded value of the key.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Permissions for the key -- read-only or full permissions.
    /// </summary>
    public BicepValue<StorageAccountKeyPermission> Permissions 
    {
        get { Initialize(); return _permissions!; }
    }
    private BicepValue<StorageAccountKeyPermission>? _permissions;

    /// <summary>
    /// Creation time of the key, in round trip date format.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// Creates a new StorageAccountKey.
    /// </summary>
    public StorageAccountKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccountKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _keyName = DefineProperty<string>("KeyName", ["keyName"], isOutput: true);
        _value = DefineProperty<string>("Value", ["value"], isOutput: true, isSecure: true);
        _permissions = DefineProperty<StorageAccountKeyPermission>("Permissions", ["permissions"], isOutput: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["creationTime"], isOutput: true);
    }
}
