// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The URIs that are used to perform a retrieval of a public blob, file, web
/// or dfs object via a internet routing endpoint.
/// </summary>
public partial class StorageAccountInternetEndpoints : ProvisionableConstruct
{
    /// <summary>
    /// Gets the blob endpoint.
    /// </summary>
    public BicepValue<Uri> BlobUri 
    {
        get { Initialize(); return _blobUri!; }
    }
    private BicepValue<Uri>? _blobUri;

    /// <summary>
    /// Gets the file endpoint.
    /// </summary>
    public BicepValue<Uri> FileUri 
    {
        get { Initialize(); return _fileUri!; }
    }
    private BicepValue<Uri>? _fileUri;

    /// <summary>
    /// Gets the web endpoint.
    /// </summary>
    public BicepValue<Uri> WebUri 
    {
        get { Initialize(); return _webUri!; }
    }
    private BicepValue<Uri>? _webUri;

    /// <summary>
    /// Gets the dfs endpoint.
    /// </summary>
    public BicepValue<Uri> DfsUri 
    {
        get { Initialize(); return _dfsUri!; }
    }
    private BicepValue<Uri>? _dfsUri;

    /// <summary>
    /// Creates a new StorageAccountInternetEndpoints.
    /// </summary>
    public StorageAccountInternetEndpoints()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountInternetEndpoints.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _blobUri = DefineProperty<Uri>("BlobUri", ["blob"], isOutput: true);
        _fileUri = DefineProperty<Uri>("FileUri", ["file"], isOutput: true);
        _webUri = DefineProperty<Uri>("WebUri", ["web"], isOutput: true);
        _dfsUri = DefineProperty<Uri>("DfsUri", ["dfs"], isOutput: true);
    }
}
