// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// IP rule with specific IP or IP range in CIDR format.
/// </summary>
public partial class StorageAccountIPRule : ProvisionableConstruct
{
    /// <summary>
    /// Specifies the IP or IP range in CIDR format. Only IPV4 address is
    /// allowed.
    /// </summary>
    public BicepValue<string> IPAddressOrRange 
    {
        get { Initialize(); return _iPAddressOrRange!; }
        set { Initialize(); _iPAddressOrRange!.Assign(value); }
    }
    private BicepValue<string>? _iPAddressOrRange;

    /// <summary>
    /// The action of IP ACL rule.
    /// </summary>
    public BicepValue<StorageAccountNetworkRuleAction> Action 
    {
        get { Initialize(); return _action!; }
        set { Initialize(); _action!.Assign(value); }
    }
    private BicepValue<StorageAccountNetworkRuleAction>? _action;

    /// <summary>
    /// Creates a new StorageAccountIPRule.
    /// </summary>
    public StorageAccountIPRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccountIPRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _iPAddressOrRange = DefineProperty<string>("IPAddressOrRange", ["value"]);
        _action = DefineProperty<StorageAccountNetworkRuleAction>("Action", ["action"]);
    }
}
