// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The URIs that are used to perform a retrieval of a public blob, queue,
/// table, web or dfs object.
/// </summary>
public partial class StorageAccountEndpoints : ProvisionableConstruct
{
    /// <summary>
    /// Gets the blob endpoint.
    /// </summary>
    public BicepValue<Uri> BlobUri 
    {
        get { Initialize(); return _blobUri!; }
    }
    private BicepValue<Uri>? _blobUri;

    /// <summary>
    /// Gets the queue endpoint.
    /// </summary>
    public BicepValue<Uri> QueueUri 
    {
        get { Initialize(); return _queueUri!; }
    }
    private BicepValue<Uri>? _queueUri;

    /// <summary>
    /// Gets the table endpoint.
    /// </summary>
    public BicepValue<Uri> TableUri 
    {
        get { Initialize(); return _tableUri!; }
    }
    private BicepValue<Uri>? _tableUri;

    /// <summary>
    /// Gets the file endpoint.
    /// </summary>
    public BicepValue<Uri> FileUri 
    {
        get { Initialize(); return _fileUri!; }
    }
    private BicepValue<Uri>? _fileUri;

    /// <summary>
    /// Gets the web endpoint.
    /// </summary>
    public BicepValue<Uri> WebUri 
    {
        get { Initialize(); return _webUri!; }
    }
    private BicepValue<Uri>? _webUri;

    /// <summary>
    /// Gets the dfs endpoint.
    /// </summary>
    public BicepValue<Uri> DfsUri 
    {
        get { Initialize(); return _dfsUri!; }
    }
    private BicepValue<Uri>? _dfsUri;

    /// <summary>
    /// Gets the microsoft routing storage endpoints.
    /// </summary>
    public StorageAccountMicrosoftEndpoints MicrosoftEndpoints 
    {
        get { Initialize(); return _microsoftEndpoints!; }
    }
    private StorageAccountMicrosoftEndpoints? _microsoftEndpoints;

    /// <summary>
    /// Gets the internet routing storage endpoints.
    /// </summary>
    public StorageAccountInternetEndpoints InternetEndpoints 
    {
        get { Initialize(); return _internetEndpoints!; }
    }
    private StorageAccountInternetEndpoints? _internetEndpoints;

    /// <summary>
    /// Creates a new StorageAccountEndpoints.
    /// </summary>
    public StorageAccountEndpoints()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccountEndpoints.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _blobUri = DefineProperty<Uri>("BlobUri", ["blob"], isOutput: true);
        _queueUri = DefineProperty<Uri>("QueueUri", ["queue"], isOutput: true);
        _tableUri = DefineProperty<Uri>("TableUri", ["table"], isOutput: true);
        _fileUri = DefineProperty<Uri>("FileUri", ["file"], isOutput: true);
        _webUri = DefineProperty<Uri>("WebUri", ["web"], isOutput: true);
        _dfsUri = DefineProperty<Uri>("DfsUri", ["dfs"], isOutput: true);
        _microsoftEndpoints = DefineModelProperty<StorageAccountMicrosoftEndpoints>("MicrosoftEndpoints", ["microsoftEndpoints"], isOutput: true);
        _internetEndpoints = DefineModelProperty<StorageAccountInternetEndpoints>("InternetEndpoints", ["internetEndpoints"], isOutput: true);
    }
}
