// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// A list of services that support encryption.
/// </summary>
public partial class StorageAccountEncryptionServices : ProvisionableConstruct
{
    /// <summary>
    /// The encryption function of the blob storage service.
    /// </summary>
    public StorageEncryptionService Blob 
    {
        get { Initialize(); return _blob!; }
        set { Initialize(); AssignOrReplace(ref _blob, value); }
    }
    private StorageEncryptionService? _blob;

    /// <summary>
    /// The encryption function of the file storage service.
    /// </summary>
    public StorageEncryptionService File 
    {
        get { Initialize(); return _file!; }
        set { Initialize(); AssignOrReplace(ref _file, value); }
    }
    private StorageEncryptionService? _file;

    /// <summary>
    /// The encryption function of the table storage service.
    /// </summary>
    public StorageEncryptionService Table 
    {
        get { Initialize(); return _table!; }
        set { Initialize(); AssignOrReplace(ref _table, value); }
    }
    private StorageEncryptionService? _table;

    /// <summary>
    /// The encryption function of the queue storage service.
    /// </summary>
    public StorageEncryptionService Queue 
    {
        get { Initialize(); return _queue!; }
        set { Initialize(); AssignOrReplace(ref _queue, value); }
    }
    private StorageEncryptionService? _queue;

    /// <summary>
    /// Creates a new StorageAccountEncryptionServices.
    /// </summary>
    public StorageAccountEncryptionServices()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// StorageAccountEncryptionServices.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _blob = DefineModelProperty<StorageEncryptionService>("Blob", ["blob"]);
        _file = DefineModelProperty<StorageEncryptionService>("File", ["file"]);
        _table = DefineModelProperty<StorageEncryptionService>("Table", ["table"]);
        _queue = DefineModelProperty<StorageEncryptionService>("Queue", ["queue"]);
    }
}
