// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The encryption settings on the storage account.
/// </summary>
public partial class StorageAccountEncryption : ProvisionableConstruct
{
    /// <summary>
    /// List of services which support encryption.
    /// </summary>
    public StorageAccountEncryptionServices Services 
    {
        get { Initialize(); return _services!; }
        set { Initialize(); AssignOrReplace(ref _services, value); }
    }
    private StorageAccountEncryptionServices? _services;

    /// <summary>
    /// The encryption keySource (provider). Possible values
    /// (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault.
    /// </summary>
    public BicepValue<StorageAccountKeySource> KeySource 
    {
        get { Initialize(); return _keySource!; }
        set { Initialize(); _keySource!.Assign(value); }
    }
    private BicepValue<StorageAccountKeySource>? _keySource;

    /// <summary>
    /// A boolean indicating whether or not the service applies a secondary
    /// layer of encryption with platform managed keys for data at rest.
    /// </summary>
    public BicepValue<bool> RequireInfrastructureEncryption 
    {
        get { Initialize(); return _requireInfrastructureEncryption!; }
        set { Initialize(); _requireInfrastructureEncryption!.Assign(value); }
    }
    private BicepValue<bool>? _requireInfrastructureEncryption;

    /// <summary>
    /// Properties provided by key vault.
    /// </summary>
    public StorageAccountKeyVaultProperties KeyVaultProperties 
    {
        get { Initialize(); return _keyVaultProperties!; }
        set { Initialize(); AssignOrReplace(ref _keyVaultProperties, value); }
    }
    private StorageAccountKeyVaultProperties? _keyVaultProperties;

    /// <summary>
    /// The identity to be used with service-side encryption at rest.
    /// </summary>
    public StorageAccountEncryptionIdentity EncryptionIdentity 
    {
        get { Initialize(); return _encryptionIdentity!; }
        set { Initialize(); AssignOrReplace(ref _encryptionIdentity, value); }
    }
    private StorageAccountEncryptionIdentity? _encryptionIdentity;

    /// <summary>
    /// Creates a new StorageAccountEncryption.
    /// </summary>
    public StorageAccountEncryption()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageAccountEncryption.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _services = DefineModelProperty<StorageAccountEncryptionServices>("Services", ["services"]);
        _keySource = DefineProperty<StorageAccountKeySource>("KeySource", ["keySource"]);
        _requireInfrastructureEncryption = DefineProperty<bool>("RequireInfrastructureEncryption", ["requireInfrastructureEncryption"]);
        _keyVaultProperties = DefineModelProperty<StorageAccountKeyVaultProperties>("KeyVaultProperties", ["keyvaultproperties"]);
        _encryptionIdentity = DefineModelProperty<StorageAccountEncryptionIdentity>("EncryptionIdentity", ["identity"]);
    }
}
