// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Setting for SMB protocol.
/// </summary>
public partial class SmbSetting : ProvisionableConstruct
{
    /// <summary>
    /// Indicates whether multichannel is enabled.
    /// </summary>
    public BicepValue<bool> IsMultiChannelEnabled 
    {
        get { Initialize(); return _isMultiChannelEnabled!; }
        set { Initialize(); _isMultiChannelEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isMultiChannelEnabled;

    /// <summary>
    /// SMB protocol versions supported by server. Valid values are SMB2.1,
    /// SMB3.0, SMB3.1.1. Should be passed as a string with delimiter
    /// &apos;;&apos;.
    /// </summary>
    public BicepValue<string> Versions 
    {
        get { Initialize(); return _versions!; }
        set { Initialize(); _versions!.Assign(value); }
    }
    private BicepValue<string>? _versions;

    /// <summary>
    /// SMB authentication methods supported by server. Valid values are
    /// NTLMv2, Kerberos. Should be passed as a string with delimiter
    /// &apos;;&apos;.
    /// </summary>
    public BicepValue<string> AuthenticationMethods 
    {
        get { Initialize(); return _authenticationMethods!; }
        set { Initialize(); _authenticationMethods!.Assign(value); }
    }
    private BicepValue<string>? _authenticationMethods;

    /// <summary>
    /// Kerberos ticket encryption supported by server. Valid values are
    /// RC4-HMAC, AES-256. Should be passed as a string with delimiter
    /// &apos;;&apos;.
    /// </summary>
    public BicepValue<string> KerberosTicketEncryption 
    {
        get { Initialize(); return _kerberosTicketEncryption!; }
        set { Initialize(); _kerberosTicketEncryption!.Assign(value); }
    }
    private BicepValue<string>? _kerberosTicketEncryption;

    /// <summary>
    /// SMB channel encryption supported by server. Valid values are
    /// AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string
    /// with delimiter &apos;;&apos;.
    /// </summary>
    public BicepValue<string> ChannelEncryption 
    {
        get { Initialize(); return _channelEncryption!; }
        set { Initialize(); _channelEncryption!.Assign(value); }
    }
    private BicepValue<string>? _channelEncryption;

    /// <summary>
    /// Creates a new SmbSetting.
    /// </summary>
    public SmbSetting()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SmbSetting.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isMultiChannelEnabled = DefineProperty<bool>("IsMultiChannelEnabled", ["multichannel", "enabled"]);
        _versions = DefineProperty<string>("Versions", ["versions"]);
        _authenticationMethods = DefineProperty<string>("AuthenticationMethods", ["authenticationMethods"]);
        _kerberosTicketEncryption = DefineProperty<string>("KerberosTicketEncryption", ["kerberosTicketEncryption"]);
        _channelEncryption = DefineProperty<string>("ChannelEncryption", ["channelEncryption"]);
    }
}
