// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The blob service properties for blob restore policy.
/// </summary>
public partial class RestorePolicy : ProvisionableConstruct
{
    /// <summary>
    /// Blob restore is enabled if set to true.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// how long this blob can be restored. It should be great than zero and
    /// less than DeleteRetentionPolicy.days.
    /// </summary>
    public BicepValue<int> Days 
    {
        get { Initialize(); return _days!; }
        set { Initialize(); _days!.Assign(value); }
    }
    private BicepValue<int>? _days;

    /// <summary>
    /// Deprecated in favor of minRestoreTime property.
    /// </summary>
    public BicepValue<DateTimeOffset> LastEnabledOn 
    {
        get { Initialize(); return _lastEnabledOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastEnabledOn;

    /// <summary>
    /// Returns the minimum date and time that the restore can be started.
    /// </summary>
    public BicepValue<DateTimeOffset> MinRestoreOn 
    {
        get { Initialize(); return _minRestoreOn!; }
    }
    private BicepValue<DateTimeOffset>? _minRestoreOn;

    /// <summary>
    /// Creates a new RestorePolicy.
    /// </summary>
    public RestorePolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RestorePolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _days = DefineProperty<int>("Days", ["days"]);
        _lastEnabledOn = DefineProperty<DateTimeOffset>("LastEnabledOn", ["lastEnabledTime"], isOutput: true);
        _minRestoreOn = DefineProperty<DateTimeOffset>("MinRestoreOn", ["minRestoreTime"], isOutput: true);
    }
}
