// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Protected append writes history setting for the blob container with Legal
/// holds.
/// </summary>
public partial class ProtectedAppendWritesHistory : ProvisionableConstruct
{
    /// <summary>
    /// When enabled, new blocks can be written to both &apos;Append and Bock
    /// Blobs&apos; while maintaining legal hold protection and compliance.
    /// Only new blocks can be added and any existing blocks cannot be
    /// modified or deleted.
    /// </summary>
    public BicepValue<bool> AllowProtectedAppendWritesAll 
    {
        get { Initialize(); return _allowProtectedAppendWritesAll!; }
    }
    private BicepValue<bool>? _allowProtectedAppendWritesAll;

    /// <summary>
    /// Returns the date and time the tag was added.
    /// </summary>
    public BicepValue<DateTimeOffset> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<DateTimeOffset>? _timestamp;

    /// <summary>
    /// Creates a new ProtectedAppendWritesHistory.
    /// </summary>
    public ProtectedAppendWritesHistory()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ProtectedAppendWritesHistory.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowProtectedAppendWritesAll = DefineProperty<bool>("AllowProtectedAppendWritesAll", ["allowProtectedAppendWritesAll"], isOutput: true);
        _timestamp = DefineProperty<DateTimeOffset>("Timestamp", ["timestamp"], isOutput: true);
    }
}
