// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The replication policy rule between two containers.
/// </summary>
public partial class ObjectReplicationPolicyRule : ProvisionableConstruct
{
    /// <summary>
    /// Rule Id is auto-generated for each new rule on destination account. It
    /// is required for put policy on source account.
    /// </summary>
    public BicepValue<string> RuleId 
    {
        get { Initialize(); return _ruleId!; }
        set { Initialize(); _ruleId!.Assign(value); }
    }
    private BicepValue<string>? _ruleId;

    /// <summary>
    /// Required. Source container name.
    /// </summary>
    public BicepValue<string> SourceContainer 
    {
        get { Initialize(); return _sourceContainer!; }
        set { Initialize(); _sourceContainer!.Assign(value); }
    }
    private BicepValue<string>? _sourceContainer;

    /// <summary>
    /// Required. Destination container name.
    /// </summary>
    public BicepValue<string> DestinationContainer 
    {
        get { Initialize(); return _destinationContainer!; }
        set { Initialize(); _destinationContainer!.Assign(value); }
    }
    private BicepValue<string>? _destinationContainer;

    /// <summary>
    /// Optional. An object that defines the filter set.
    /// </summary>
    public ObjectReplicationPolicyFilter Filters 
    {
        get { Initialize(); return _filters!; }
        set { Initialize(); AssignOrReplace(ref _filters, value); }
    }
    private ObjectReplicationPolicyFilter? _filters;

    /// <summary>
    /// Creates a new ObjectReplicationPolicyRule.
    /// </summary>
    public ObjectReplicationPolicyRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ObjectReplicationPolicyRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _ruleId = DefineProperty<string>("RuleId", ["ruleId"]);
        _sourceContainer = DefineProperty<string>("SourceContainer", ["sourceContainer"]);
        _destinationContainer = DefineProperty<string>("DestinationContainer", ["destinationContainer"]);
        _filters = DefineModelProperty<ObjectReplicationPolicyFilter>("Filters", ["filters"]);
    }
}
