// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Filters limit replication to a subset of blobs within the storage account.
/// A logical OR is performed on values in the filter. If multiple filters are
/// defined, a logical AND is performed on all filters.
/// </summary>
public partial class ObjectReplicationPolicyFilter : ProvisionableConstruct
{
    /// <summary>
    /// Optional. Filters the results to replicate only blobs whose names begin
    /// with the specified prefix.
    /// </summary>
    public BicepList<string> PrefixMatch 
    {
        get { Initialize(); return _prefixMatch!; }
        set { Initialize(); _prefixMatch!.Assign(value); }
    }
    private BicepList<string>? _prefixMatch;

    /// <summary>
    /// Blobs created after the time will be replicated to the destination. It
    /// must be in datetime format &apos;yyyy-MM-ddTHH:mm:ssZ&apos;. Example:
    /// 2020-02-19T16:05:00Z.
    /// </summary>
    public BicepValue<string> MinCreationTime 
    {
        get { Initialize(); return _minCreationTime!; }
        set { Initialize(); _minCreationTime!.Assign(value); }
    }
    private BicepValue<string>? _minCreationTime;

    /// <summary>
    /// Creates a new ObjectReplicationPolicyFilter.
    /// </summary>
    public ObjectReplicationPolicyFilter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ObjectReplicationPolicyFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _prefixMatch = DefineListProperty<string>("PrefixMatch", ["prefixMatch"]);
        _minCreationTime = DefineProperty<string>("MinCreationTime", ["minCreationTime"]);
    }
}
