// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Blob index tag based filtering for blob objects.
/// </summary>
public partial class ManagementPolicyTagFilter : ProvisionableConstruct
{
    /// <summary>
    /// This is the filter tag name, it can have 1 - 128 characters.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// This is the comparison operator which is used for object comparison and
    /// filtering. Only == (equality operator) is currently supported.
    /// </summary>
    public BicepValue<string> Operator 
    {
        get { Initialize(); return _operator!; }
        set { Initialize(); _operator!.Assign(value); }
    }
    private BicepValue<string>? _operator;

    /// <summary>
    /// This is the filter tag value field used for tag based filtering, it can
    /// have 0 - 256 characters.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Creates a new ManagementPolicyTagFilter.
    /// </summary>
    public ManagementPolicyTagFilter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementPolicyTagFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _operator = DefineProperty<string>("Operator", ["op"]);
        _value = DefineProperty<string>("Value", ["value"]);
    }
}
