// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Management policy action for snapshot.
/// </summary>
public partial class ManagementPolicySnapShot : ProvisionableConstruct
{
    /// <summary>
    /// The function to tier blob snapshot to cool storage.
    /// </summary>
    public DateAfterCreation TierToCool 
    {
        get { Initialize(); return _tierToCool!; }
        set { Initialize(); AssignOrReplace(ref _tierToCool, value); }
    }
    private DateAfterCreation? _tierToCool;

    /// <summary>
    /// The function to tier blob snapshot to archive storage.
    /// </summary>
    public DateAfterCreation TierToArchive 
    {
        get { Initialize(); return _tierToArchive!; }
        set { Initialize(); AssignOrReplace(ref _tierToArchive, value); }
    }
    private DateAfterCreation? _tierToArchive;

    /// <summary>
    /// The function to tier blobs to cold storage.
    /// </summary>
    public DateAfterCreation TierToCold 
    {
        get { Initialize(); return _tierToCold!; }
        set { Initialize(); AssignOrReplace(ref _tierToCold, value); }
    }
    private DateAfterCreation? _tierToCold;

    /// <summary>
    /// The function to tier blobs to hot storage. This action can only be used
    /// with Premium Block Blob Storage Accounts.
    /// </summary>
    public DateAfterCreation TierToHot 
    {
        get { Initialize(); return _tierToHot!; }
        set { Initialize(); AssignOrReplace(ref _tierToHot, value); }
    }
    private DateAfterCreation? _tierToHot;

    /// <summary>
    /// The function to delete the blob snapshot.
    /// </summary>
    public DateAfterCreation Delete 
    {
        get { Initialize(); return _delete!; }
        set { Initialize(); AssignOrReplace(ref _delete, value); }
    }
    private DateAfterCreation? _delete;

    /// <summary>
    /// Creates a new ManagementPolicySnapShot.
    /// </summary>
    public ManagementPolicySnapShot()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementPolicySnapShot.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tierToCool = DefineModelProperty<DateAfterCreation>("TierToCool", ["tierToCool"]);
        _tierToArchive = DefineModelProperty<DateAfterCreation>("TierToArchive", ["tierToArchive"]);
        _tierToCold = DefineModelProperty<DateAfterCreation>("TierToCold", ["tierToCold"]);
        _tierToHot = DefineModelProperty<DateAfterCreation>("TierToHot", ["tierToHot"]);
        _delete = DefineModelProperty<DateAfterCreation>("Delete", ["delete"]);
    }
}
