// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Filters limit rule actions to a subset of blobs within the storage account.
/// If multiple filters are defined, a logical AND is performed on all filters.
/// </summary>
public partial class ManagementPolicyFilter : ProvisionableConstruct
{
    /// <summary>
    /// An array of strings for prefixes to be match.
    /// </summary>
    public BicepList<string> PrefixMatch 
    {
        get { Initialize(); return _prefixMatch!; }
        set { Initialize(); _prefixMatch!.Assign(value); }
    }
    private BicepList<string>? _prefixMatch;

    /// <summary>
    /// An array of predefined enum values. Currently blockBlob supports all
    /// tiering and delete actions. Only delete actions are supported for
    /// appendBlob.
    /// </summary>
    public BicepList<string> BlobTypes 
    {
        get { Initialize(); return _blobTypes!; }
        set { Initialize(); _blobTypes!.Assign(value); }
    }
    private BicepList<string>? _blobTypes;

    /// <summary>
    /// An array of blob index tag based filters, there can be at most 10 tag
    /// filters.
    /// </summary>
    public BicepList<ManagementPolicyTagFilter> BlobIndexMatch 
    {
        get { Initialize(); return _blobIndexMatch!; }
        set { Initialize(); _blobIndexMatch!.Assign(value); }
    }
    private BicepList<ManagementPolicyTagFilter>? _blobIndexMatch;

    /// <summary>
    /// Creates a new ManagementPolicyFilter.
    /// </summary>
    public ManagementPolicyFilter()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementPolicyFilter.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _prefixMatch = DefineListProperty<string>("PrefixMatch", ["prefixMatch"]);
        _blobTypes = DefineListProperty<string>("BlobTypes", ["blobTypes"]);
        _blobIndexMatch = DefineListProperty<ManagementPolicyTagFilter>("BlobIndexMatch", ["blobIndexMatch"]);
    }
}
