// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// An object that defines the Lifecycle rule. Each definition is made up with
/// a filters set and an actions set.
/// </summary>
public partial class ManagementPolicyDefinition : ProvisionableConstruct
{
    /// <summary>
    /// An object that defines the action set.
    /// </summary>
    public ManagementPolicyAction Actions 
    {
        get { Initialize(); return _actions!; }
        set { Initialize(); AssignOrReplace(ref _actions, value); }
    }
    private ManagementPolicyAction? _actions;

    /// <summary>
    /// An object that defines the filter set.
    /// </summary>
    public ManagementPolicyFilter Filters 
    {
        get { Initialize(); return _filters!; }
        set { Initialize(); AssignOrReplace(ref _filters, value); }
    }
    private ManagementPolicyFilter? _filters;

    /// <summary>
    /// Creates a new ManagementPolicyDefinition.
    /// </summary>
    public ManagementPolicyDefinition()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementPolicyDefinition.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _actions = DefineModelProperty<ManagementPolicyAction>("Actions", ["actions"]);
        _filters = DefineModelProperty<ManagementPolicyFilter>("Filters", ["filters"]);
    }
}
