// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Management policy action for base blob.
/// </summary>
public partial class ManagementPolicyBaseBlob : ProvisionableConstruct
{
    /// <summary>
    /// The function to tier blobs to cool storage.
    /// </summary>
    public DateAfterModification TierToCool 
    {
        get { Initialize(); return _tierToCool!; }
        set { Initialize(); AssignOrReplace(ref _tierToCool, value); }
    }
    private DateAfterModification? _tierToCool;

    /// <summary>
    /// The function to tier blobs to archive storage.
    /// </summary>
    public DateAfterModification TierToArchive 
    {
        get { Initialize(); return _tierToArchive!; }
        set { Initialize(); AssignOrReplace(ref _tierToArchive, value); }
    }
    private DateAfterModification? _tierToArchive;

    /// <summary>
    /// The function to tier blobs to cold storage.
    /// </summary>
    public DateAfterModification TierToCold 
    {
        get { Initialize(); return _tierToCold!; }
        set { Initialize(); AssignOrReplace(ref _tierToCold, value); }
    }
    private DateAfterModification? _tierToCold;

    /// <summary>
    /// The function to tier blobs to hot storage. This action can only be used
    /// with Premium Block Blob Storage Accounts.
    /// </summary>
    public DateAfterModification TierToHot 
    {
        get { Initialize(); return _tierToHot!; }
        set { Initialize(); AssignOrReplace(ref _tierToHot, value); }
    }
    private DateAfterModification? _tierToHot;

    /// <summary>
    /// The function to delete the blob.
    /// </summary>
    public DateAfterModification Delete 
    {
        get { Initialize(); return _delete!; }
        set { Initialize(); AssignOrReplace(ref _delete, value); }
    }
    private DateAfterModification? _delete;

    /// <summary>
    /// This property enables auto tiering of a blob from cool to hot on a blob
    /// access. This property requires
    /// tierToCool.daysAfterLastAccessTimeGreaterThan.
    /// </summary>
    public BicepValue<bool> EnableAutoTierToHotFromCool 
    {
        get { Initialize(); return _enableAutoTierToHotFromCool!; }
        set { Initialize(); _enableAutoTierToHotFromCool!.Assign(value); }
    }
    private BicepValue<bool>? _enableAutoTierToHotFromCool;

    /// <summary>
    /// Creates a new ManagementPolicyBaseBlob.
    /// </summary>
    public ManagementPolicyBaseBlob()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementPolicyBaseBlob.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tierToCool = DefineModelProperty<DateAfterModification>("TierToCool", ["tierToCool"]);
        _tierToArchive = DefineModelProperty<DateAfterModification>("TierToArchive", ["tierToArchive"]);
        _tierToCold = DefineModelProperty<DateAfterModification>("TierToCold", ["tierToCold"]);
        _tierToHot = DefineModelProperty<DateAfterModification>("TierToHot", ["tierToHot"]);
        _delete = DefineModelProperty<DateAfterModification>("Delete", ["delete"]);
        _enableAutoTierToHotFromCool = DefineProperty<bool>("EnableAutoTierToHotFromCool", ["enableAutoTierToHotFromCool"]);
    }
}
