// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Actions are applied to the filtered blobs when the execution condition is
/// met.
/// </summary>
public partial class ManagementPolicyAction : ProvisionableConstruct
{
    /// <summary>
    /// The management policy action for base blob.
    /// </summary>
    public ManagementPolicyBaseBlob BaseBlob 
    {
        get { Initialize(); return _baseBlob!; }
        set { Initialize(); AssignOrReplace(ref _baseBlob, value); }
    }
    private ManagementPolicyBaseBlob? _baseBlob;

    /// <summary>
    /// The management policy action for snapshot.
    /// </summary>
    public ManagementPolicySnapShot Snapshot 
    {
        get { Initialize(); return _snapshot!; }
        set { Initialize(); AssignOrReplace(ref _snapshot, value); }
    }
    private ManagementPolicySnapShot? _snapshot;

    /// <summary>
    /// The management policy action for version.
    /// </summary>
    public ManagementPolicyVersion Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); AssignOrReplace(ref _version, value); }
    }
    private ManagementPolicyVersion? _version;

    /// <summary>
    /// Creates a new ManagementPolicyAction.
    /// </summary>
    public ManagementPolicyAction()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ManagementPolicyAction.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _baseBlob = DefineModelProperty<ManagementPolicyBaseBlob>("BaseBlob", ["baseBlob"]);
        _snapshot = DefineModelProperty<ManagementPolicySnapShot>("Snapshot", ["snapshot"]);
        _version = DefineModelProperty<ManagementPolicyVersion>("Version", ["version"]);
    }
}
