// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The Storage Account Local User keys.
/// </summary>
public partial class LocalUserKeys : ProvisionableConstruct
{
    /// <summary>
    /// Optional, local user ssh authorized keys for SFTP.
    /// </summary>
    public BicepList<StorageSshPublicKey> SshAuthorizedKeys 
    {
        get { Initialize(); return _sshAuthorizedKeys!; }
    }
    private BicepList<StorageSshPublicKey>? _sshAuthorizedKeys;

    /// <summary>
    /// Auto generated by the server for SMB authentication.
    /// </summary>
    public BicepValue<string> SharedKey 
    {
        get { Initialize(); return _sharedKey!; }
    }
    private BicepValue<string>? _sharedKey;

    /// <summary>
    /// Creates a new LocalUserKeys.
    /// </summary>
    public LocalUserKeys()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LocalUserKeys.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sshAuthorizedKeys = DefineListProperty<StorageSshPublicKey>("SshAuthorizedKeys", ["sshAuthorizedKeys"], isOutput: true);
        _sharedKey = DefineProperty<string>("SharedKey", ["sharedKey"], isOutput: true, isSecure: true);
    }
}
