// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// A tag of the LegalHold of a blob container.
/// </summary>
public partial class LegalHoldTag : ProvisionableConstruct
{
    /// <summary>
    /// The tag value.
    /// </summary>
    public BicepValue<string> Tag 
    {
        get { Initialize(); return _tag!; }
    }
    private BicepValue<string>? _tag;

    /// <summary>
    /// Returns the date and time the tag was added.
    /// </summary>
    public BicepValue<DateTimeOffset> Timestamp 
    {
        get { Initialize(); return _timestamp!; }
    }
    private BicepValue<DateTimeOffset>? _timestamp;

    /// <summary>
    /// Returns the Object ID of the user who added the tag.
    /// </summary>
    public BicepValue<string> ObjectIdentifier 
    {
        get { Initialize(); return _objectIdentifier!; }
    }
    private BicepValue<string>? _objectIdentifier;

    /// <summary>
    /// Returns the Tenant ID that issued the token for the user who added the
    /// tag.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Returns the User Principal Name of the user who added the tag.
    /// </summary>
    public BicepValue<string> Upn 
    {
        get { Initialize(); return _upn!; }
    }
    private BicepValue<string>? _upn;

    /// <summary>
    /// Creates a new LegalHoldTag.
    /// </summary>
    public LegalHoldTag()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LegalHoldTag.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _tag = DefineProperty<string>("Tag", ["tag"], isOutput: true);
        _timestamp = DefineProperty<DateTimeOffset>("Timestamp", ["timestamp"], isOutput: true);
        _objectIdentifier = DefineProperty<string>("ObjectIdentifier", ["objectIdentifier"], isOutput: true);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
        _upn = DefineProperty<string>("Upn", ["upn"], isOutput: true);
    }
}
