// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The LegalHold property of a blob container.
/// </summary>
public partial class LegalHoldProperties : ProvisionableConstruct
{
    /// <summary>
    /// The hasLegalHold public property is set to true by SRP if there are at
    /// least one existing tag. The hasLegalHold public property is set to
    /// false by SRP if all existing legal hold tags are cleared out. There
    /// can be a maximum of 1000 blob containers with hasLegalHold=true for a
    /// given account.
    /// </summary>
    public BicepValue<bool> HasLegalHold 
    {
        get { Initialize(); return _hasLegalHold!; }
    }
    private BicepValue<bool>? _hasLegalHold;

    /// <summary>
    /// The list of LegalHold tags of a blob container.
    /// </summary>
    public BicepList<LegalHoldTag> Tags 
    {
        get { Initialize(); return _tags!; }
    }
    private BicepList<LegalHoldTag>? _tags;

    /// <summary>
    /// Protected append blob writes history.
    /// </summary>
    public ProtectedAppendWritesHistory ProtectedAppendWritesHistory 
    {
        get { Initialize(); return _protectedAppendWritesHistory!; }
    }
    private ProtectedAppendWritesHistory? _protectedAppendWritesHistory;

    /// <summary>
    /// Creates a new LegalHoldProperties.
    /// </summary>
    public LegalHoldProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LegalHoldProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _hasLegalHold = DefineProperty<bool>("HasLegalHold", ["hasLegalHold"], isOutput: true);
        _tags = DefineListProperty<LegalHoldTag>("Tags", ["tags"], isOutput: true);
        _protectedAppendWritesHistory = DefineModelProperty<ProtectedAppendWritesHistory>("ProtectedAppendWritesHistory", ["protectedAppendWritesHistory"], isOutput: true);
    }
}
