// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// The blob service properties for Last access time based tracking policy.
/// </summary>
public partial class LastAccessTimeTrackingPolicy : ProvisionableConstruct
{
    /// <summary>
    /// When set to true last access time based tracking is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Name of the policy. The valid value is AccessTimeTracking. This field
    /// is currently read only.
    /// </summary>
    public BicepValue<LastAccessTimeTrackingPolicyName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<LastAccessTimeTrackingPolicyName>? _name;

    /// <summary>
    /// The field specifies blob object tracking granularity in days, typically
    /// how often the blob object should be tracked.This field is currently
    /// read only with value as 1.
    /// </summary>
    public BicepValue<int> TrackingGranularityInDays 
    {
        get { Initialize(); return _trackingGranularityInDays!; }
        set { Initialize(); _trackingGranularityInDays!.Assign(value); }
    }
    private BicepValue<int>? _trackingGranularityInDays;

    /// <summary>
    /// An array of predefined supported blob types. Only blockBlob is the
    /// supported value. This field is currently read only.
    /// </summary>
    public BicepList<string> BlobType 
    {
        get { Initialize(); return _blobType!; }
        set { Initialize(); _blobType!.Assign(value); }
    }
    private BicepList<string>? _blobType;

    /// <summary>
    /// Creates a new LastAccessTimeTrackingPolicy.
    /// </summary>
    public LastAccessTimeTrackingPolicy()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LastAccessTimeTrackingPolicy.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enable"]);
        _name = DefineProperty<LastAccessTimeTrackingPolicyName>("Name", ["name"]);
        _trackingGranularityInDays = DefineProperty<int>("TrackingGranularityInDays", ["trackingGranularityInDays"]);
        _blobType = DefineListProperty<string>("BlobType", ["blobType"]);
    }
}
