// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// Object level immutability properties of the container.
/// </summary>
public partial class ImmutableStorageWithVersioning : ProvisionableConstruct
{
    /// <summary>
    /// This is an immutable property, when set to true it enables object level
    /// immutability at the container level.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Returns the date and time the object level immutability was enabled.
    /// </summary>
    public BicepValue<DateTimeOffset> TimeStamp 
    {
        get { Initialize(); return _timeStamp!; }
    }
    private BicepValue<DateTimeOffset>? _timeStamp;

    /// <summary>
    /// This property denotes the container level immutability to object level
    /// immutability migration state.
    /// </summary>
    public BicepValue<ImmutableStorageWithVersioningMigrationState> MigrationState 
    {
        get { Initialize(); return _migrationState!; }
    }
    private BicepValue<ImmutableStorageWithVersioningMigrationState>? _migrationState;

    /// <summary>
    /// Creates a new ImmutableStorageWithVersioning.
    /// </summary>
    public ImmutableStorageWithVersioning()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ImmutableStorageWithVersioning.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _timeStamp = DefineProperty<DateTimeOffset>("TimeStamp", ["timeStamp"], isOutput: true);
        _migrationState = DefineProperty<ImmutableStorageWithVersioningMigrationState>("MigrationState", ["migrationState"], isOutput: true);
    }
}
