// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Storage;

/// <summary>
/// This property enables and defines account-level immutability. Enabling the
/// feature auto-enables Blob Versioning.
/// </summary>
public partial class ImmutableStorageAccount : ProvisionableConstruct
{
    /// <summary>
    /// A boolean flag which enables account-level immutability. All the
    /// containers under such an account have object-level immutability
    /// enabled by default.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Specifies the default account-level immutability policy which is
    /// inherited and applied to objects that do not possess an explicit
    /// immutability policy at the object level. The object-level immutability
    /// policy has higher precedence than the container-level immutability
    /// policy, which has a higher precedence than the account-level
    /// immutability policy.
    /// </summary>
    public AccountImmutabilityPolicy ImmutabilityPolicy 
    {
        get { Initialize(); return _immutabilityPolicy!; }
        set { Initialize(); AssignOrReplace(ref _immutabilityPolicy, value); }
    }
    private AccountImmutabilityPolicy? _immutabilityPolicy;

    /// <summary>
    /// Creates a new ImmutableStorageAccount.
    /// </summary>
    public ImmutableStorageAccount()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ImmutableStorageAccount.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _immutabilityPolicy = DefineModelProperty<AccountImmutabilityPolicy>("ImmutabilityPolicy", ["immutabilityPolicy"]);
    }
}
